/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util.featuregen;

import java.util.List;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.util.Span;
import opennlp.tools.util.featuregen.FeatureGeneratorAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InSpanGenerator
extends FeatureGeneratorAdapter {
    private final String prefix;
    private final TokenNameFinder finder;
    private String[] currentSentence;
    private Span[] currentNames;

    public InSpanGenerator(String prefix, TokenNameFinder finder) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix must not be null!");
        }
        this.prefix = prefix;
        if (finder == null) {
            throw new IllegalArgumentException("finder must not be null!");
        }
        this.finder = finder;
    }

    @Override
    public void createFeatures(List<String> features, String[] tokens, int index, String[] preds) {
        if (this.currentSentence != tokens) {
            this.currentSentence = tokens;
            this.currentNames = this.finder.find(tokens);
        }
        for (Span currentName : this.currentNames) {
            if (!currentName.contains(index)) continue;
            features.add(this.prefix + ":w=dic");
            features.add(this.prefix + ":w=dic=" + tokens[index]);
            break;
        }
    }
}

