/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.coref.sim;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import opennlp.maxent.Event;
import opennlp.maxent.EventStream;
import opennlp.maxent.GIS;
import opennlp.maxent.MaxentModel;
import opennlp.maxent.io.SuffixSensitiveGISModelReader;
import opennlp.maxent.io.SuffixSensitiveGISModelWriter;
import opennlp.tools.coref.Linker;
import opennlp.tools.coref.sim.Context;
import opennlp.tools.coref.sim.NumberEnum;
import opennlp.tools.coref.sim.TestNumberModel;
import opennlp.tools.coref.sim.TrainSimilarityModel;
import opennlp.tools.util.CollectionEventStream;
import opennlp.tools.util.HashList;

public class NumberModel
implements TestNumberModel,
TrainSimilarityModel {
    private String modelName;
    private String modelExtension = ".bin.gz";
    private MaxentModel testModel;
    private List events;
    private int singularIndex;
    private int pluralIndex;

    public static TestNumberModel testModel(String name) throws IOException {
        NumberModel nm = new NumberModel(name, false);
        return nm;
    }

    public static TrainSimilarityModel trainModel(String modelName) throws IOException {
        NumberModel gm = new NumberModel(modelName, true);
        return gm;
    }

    private NumberModel(String modelName, boolean train) throws IOException {
        this.modelName = modelName;
        if (train) {
            this.events = new ArrayList();
        } else {
            this.testModel = new SuffixSensitiveGISModelReader(new File(modelName + this.modelExtension)).getModel();
            this.singularIndex = this.testModel.getIndex(NumberEnum.SINGULAR.toString());
            this.pluralIndex = this.testModel.getIndex(NumberEnum.PLURAL.toString());
        }
    }

    private List getFeatures(Context np1) {
        ArrayList<String> features = new ArrayList<String>();
        features.add("default");
        Object[] npTokens = np1.getTokens();
        int tl = npTokens.length - 1;
        for (int ti = 0; ti < tl; ++ti) {
            features.add("mw=" + npTokens[ti].toString());
        }
        features.add("hw=" + np1.getHeadTokenText().toLowerCase());
        features.add("ht=" + np1.getHeadTokenTag());
        return features;
    }

    private void addEvent(String outcome, Context np1) {
        List feats = this.getFeatures(np1);
        this.events.add(new Event(outcome, feats.toArray(new String[feats.size()])));
    }

    public NumberEnum getNumber(Context ec) {
        if (Linker.singularPronounPattern.matcher(ec.getHeadTokenText()).matches()) {
            return NumberEnum.SINGULAR;
        }
        if (Linker.pluralPronounPattern.matcher(ec.getHeadTokenText()).matches()) {
            return NumberEnum.PLURAL;
        }
        return NumberEnum.UNKNOWN;
    }

    private NumberEnum getNumber(List entity) {
        Iterator ci = entity.iterator();
        while (ci.hasNext()) {
            Context ec = (Context)ci.next();
            NumberEnum ne = this.getNumber(ec);
            if (ne == NumberEnum.UNKNOWN) continue;
            return ne;
        }
        return NumberEnum.UNKNOWN;
    }

    public void setExtents(Context[] extentContexts) {
        Context ec;
        HashList entities = new HashList();
        ArrayList<Context> singletons = new ArrayList<Context>();
        int el = extentContexts.length;
        for (int ei = 0; ei < el; ++ei) {
            Context ec2 = extentContexts[ei];
            if (ec2.getId() != -1) {
                entities.put(new Integer(ec2.getId()), ec2);
                continue;
            }
            singletons.add(ec2);
        }
        ArrayList<Context> singles = new ArrayList<Context>();
        ArrayList<Context> plurals = new ArrayList<Context>();
        Iterator<Object> ei = entities.keySet().iterator();
        while (ei.hasNext()) {
            Integer key = (Integer)ei.next();
            List entityContexts = (List)entities.get(key);
            NumberEnum number = this.getNumber(entityContexts);
            if (number == NumberEnum.SINGULAR) {
                singles.addAll(entityContexts);
                continue;
            }
            if (number != NumberEnum.PLURAL) continue;
            plurals.addAll(entityContexts);
        }
        ei = singletons.iterator();
        while (ei.hasNext()) {
            ec = (Context)ei.next();
            NumberEnum number = this.getNumber(ec);
            if (number == NumberEnum.SINGULAR) {
                singles.add(ec);
                continue;
            }
            if (number != NumberEnum.PLURAL) continue;
            plurals.add(ec);
        }
        Iterator si = singles.iterator();
        while (si.hasNext()) {
            ec = (Context)si.next();
            this.addEvent(NumberEnum.SINGULAR.toString(), ec);
        }
        Iterator fi = plurals.iterator();
        while (fi.hasNext()) {
            ec = (Context)fi.next();
            this.addEvent(NumberEnum.PLURAL.toString(), ec);
        }
    }

    public double[] numberDist(Context c) {
        List feats = this.getFeatures(c);
        return this.testModel.eval(feats.toArray(new String[feats.size()]));
    }

    public int getSingularIndex() {
        return this.singularIndex;
    }

    public int getPluralIndex() {
        return this.pluralIndex;
    }

    public void trainModel() throws IOException {
        new SuffixSensitiveGISModelWriter(GIS.trainModel((EventStream)new CollectionEventStream(this.events), (int)100, (int)10), new File(this.modelName + this.modelExtension)).persist();
    }
}

