/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.postag;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import opennlp.tools.util.CountedSet;

public class POSDictionaryWriter {
    private Writer dictFile;
    private Map dictionary;
    private CountedSet wordCounts;
    private String newline = System.getProperty("line.separator");

    public POSDictionaryWriter(String file) throws IOException {
        this.dictFile = new FileWriter(file);
        this.dictionary = new HashMap();
        this.wordCounts = new CountedSet();
    }

    public void addEntry(String word, String tag) {
        HashSet<String> tags = (HashSet<String>)this.dictionary.get(word);
        if (tags == null) {
            tags = new HashSet<String>();
            this.dictionary.put(word, tags);
        }
        tags.add(tag);
        this.wordCounts.add(word);
    }

    public void write() throws IOException {
        this.write(5);
    }

    public void write(int cutoff) throws IOException {
        for (String word : this.wordCounts) {
            if (this.wordCounts.getCount(word) < cutoff) continue;
            this.dictFile.write(word);
            Set tags = (Set)this.dictionary.get(word);
            Iterator ti = tags.iterator();
            while (ti.hasNext()) {
                this.dictFile.write(" ");
                this.dictFile.write((String)ti.next());
            }
            this.dictFile.write(this.newline);
        }
        this.dictFile.close();
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Usage: POSDictionaryWriter dictionary tag_files");
            System.exit(1);
        }
        int ai = 0;
        String dictionaryFile = args[ai++];
        POSDictionaryWriter dict = new POSDictionaryWriter(dictionaryFile);
        for (int fi = ai; fi < args.length; ++fi) {
            BufferedReader in = new BufferedReader(new FileReader(args[fi]));
            String line = in.readLine();
            while (line != null) {
                String[] parts = line.split("\\s+");
                for (int pi = 0; pi < parts.length; ++pi) {
                    int index = parts[pi].lastIndexOf(95);
                    String word = parts[pi].substring(0, index);
                    String tag = parts[pi].substring(index + 1);
                    dict.addEntry(word, tag);
                }
                line = in.readLine();
            }
        }
        dict.write();
    }
}

