% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opart_poission.R
\name{opart_poisson}
\alias{opart_poisson}
\title{compute the optimal changepoint model for a vector of real-valued data
and a non-negative real-valued penalty,
given the poisson loss (to minimize) / log likelihood (to maximize)}
\usage{
opart_poisson(data, penalty)
}
\arguments{
\item{data}{A list of numbers for which the changepoint model is to be computed}

\item{penalty}{A non-negative real number indicating penalty parameter}
}
\value{
An error status code with a pointer to the optimal cost values and a pointer to the optimal segment ends
}
\description{
compute the optimal changepoint model for a vector of real-valued data
and a non-negative real-valued penalty,
given the poisson loss (to minimize) / log likelihood (to maximize)
}
\examples{
sample_data <- rpois(100, 10.5)
opart::opart_poisson(data=sample_data, penalty=1)
}
