% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.resource.R
\name{opal.resource_perm}
\alias{opal.resource_perm}
\title{Get the permissions on a resource}
\usage{
opal.resource_perm(opal, project, resource)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{The project name.}

\item{resource}{The resource name.}
}
\value{
A data.frame with columns: subject, type, permission
}
\description{
Get the permissions that were applied on a resource.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.resource_perm_add(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user', 'view')
opal.resource_perm(o, 'CNSIM', 'CNSIM1')
opal.resource_perm_delete(o, 'CNSIM', 'CNSIM1', c('andrei', 'valentina'), 'user')
opal.logout(o)
}
}
