% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opal.resource.r
\name{opal.resource_delete}
\alias{opal.resource_delete}
\title{Delete a resource reference}
\usage{
opal.resource_delete(opal, project, resource, silent = TRUE)
}
\arguments{
\item{opal}{Opal connection object.}

\item{project}{Project name where the resource is located.}

\item{resource}{Resource name to be deleted.}

\item{silent}{Warn if resource does not exist, default is TRUE.}
}
\description{
Removes the reference to a resource. The targeted resource remains untouched.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
opal.resource_delete(o, "RSRC", "CNSIM4")
opal.logout(o)
}
}
