% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datashield.admin.r
\name{dsadmin.install_github_package}
\alias{dsadmin.install_github_package}
\title{Install a DataSHIELD package from GitHub}
\usage{
dsadmin.install_github_package(
  opal,
  pkg,
  username = "datashield",
  ref = "master"
)
}
\arguments{
\item{opal}{Opal object or list of opal objects.}

\item{pkg}{Package name.}

\item{username}{GitHub username/organization of the git repository. Default is 'datashield'.}

\item{ref}{Desired git reference (could be a commit, tag, or branch name). Default is 'master'.}
}
\value{
TRUE if installed
}
\description{
Install a package from a DataSHIELD source repository on GitHub.
}
\examples{
\dontrun{
o <- opal.login('administrator','password', url='https://opal-demo.obiba.org')
dsadmin.install_github_package(o, 'dsOmics', username='isglobal-brge')
opal.logout(o)
}
}
\seealso{
Other DataSHIELD functions: 
\code{\link{dsadmin.get_methods}()},
\code{\link{dsadmin.get_method}()},
\code{\link{dsadmin.get_options}()},
\code{\link{dsadmin.install_local_package}()},
\code{\link{dsadmin.install_package}()},
\code{\link{dsadmin.installed_package}()},
\code{\link{dsadmin.package_descriptions}()},
\code{\link{dsadmin.package_description}()},
\code{\link{dsadmin.remove_package}()},
\code{\link{dsadmin.rm_methods}()},
\code{\link{dsadmin.rm_method}()},
\code{\link{dsadmin.rm_option}()},
\code{\link{dsadmin.rm_package_methods}()},
\code{\link{dsadmin.set_method}()},
\code{\link{dsadmin.set_option}()},
\code{\link{dsadmin.set_package_methods}()}
}
\concept{DataSHIELD functions}
