## -----------------------------------------------------------------------------
# Keep it in D to simplify notation
D <- Dbuilding

## -----------------------------------------------------------------------------
# The class of D
class(D)

## -----------------------------------------------------------------------------
# Print the names to see the variables in the data
names(D)

## -----------------------------------------------------------------------------
# The time
class(D$t)
head(D$t)
tail(D$t)

## -----------------------------------------------------------------------------
# Convert from a time stamp (tz="GMT" per default)
ct("2019-01-01 11:00")
# Convert from unix time
ct(3840928387)

## -----------------------------------------------------------------------------
# Same length as time
length(D$t)
length(D$heatload)

## -----------------------------------------------------------------------------
# The observation
D$heatload[2]
# Represents the average load between
D$t[1]
# and
D$t[2]

## -----------------------------------------------------------------------------
# Global radiation forecasts
head(D$I)

## -----------------------------------------------------------------------------
# First time point
D$t[1]

## -----------------------------------------------------------------------------
# The forecast available ahead in time is in the first row
D$I[1, ]

## -----------------------------------------------------------------------------
# Just pick some points by
i <- 200:296
plot(D$t[i], D$I$k8[i], type="l", col=2, xlab="Time", ylab="Global radiation (W/m²)")
# Add the observations
lines(D$t[i], D$Iobs[i])
legend("topright", c("8-step forecasts","Observations"), bg="white", lty=1, col=2:1)

## ---- fig.width=fhs, fig.height=fhs, out.width=ows----------------------------
# Lag the 8-step forecasts to be aligned with the observations
x <- lagvec(D$I$k8, 8)
# Take a smaller range
x <- x[i]
# Take the observations
y <- D$Iobs[i]
# Fit a linear regression model
fit <- lm(y ~ x)
# Plot the result
plot(x, y, xlab="8-step forecasts (W/m²)", ylab="Obsservations (W/m²)", main="Global radiation")
abline(fit)

## -----------------------------------------------------------------------------
# Take the 1 to 4 values of each variable in D
Dsub <- subset(D, 1:4)
summary(Dsub)

## -----------------------------------------------------------------------------
# Set back to data.frame
setDF(Df)
# Convert to a data.list
Dsub2 <- as.data.list(Df)
# Compare it with the original Dsub
summary(Dsub2)
summary(Dsub)

