% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ug.R
\name{ug}
\alias{ug}
\title{Unidirectional Growth}
\usage{
ug(
  input.seq,
  LOD = 0,
  max.rf = 0.5,
  tol = 1e-04,
  rm_unlinked = TRUE,
  size = NULL,
  overlap = NULL,
  phase_cores = 1,
  hmm = TRUE,
  parallelization.type = "PSOCK",
  verbose = TRUE
)
}
\arguments{
\item{input.seq}{an object of class \code{sequence}.}

\item{LOD}{minimum LOD-Score threshold used when constructing the pairwise
recombination fraction matrix.}

\item{max.rf}{maximum recombination fraction threshold used as the LOD
value above.}

\item{tol}{tolerance for the C routine, i.e., the value used to evaluate
convergence.}

\item{rm_unlinked}{When some pair of markers do not follow the linkage criteria, 
if \code{TRUE} one of the markers is removed and ug is performed again.}

\item{size}{The center size around which an optimum is to be searched}

\item{overlap}{The desired overlap between batches}

\item{phase_cores}{The number of parallel processes to use when estimating
the phase of a marker. (Should be no more than 4)}

\item{hmm}{logical defining if the HMM must be applied to estimate multipoint
genetic distances}

\item{parallelization.type}{one of the supported cluster types. This should 
be either PSOCK (default) or FORK.}

\item{verbose}{A logical, if TRUE it output progress status
information.}
}
\value{
An object of class \code{sequence}, which is a list containing the
following components: \item{seq.num}{a \code{vector} containing the
(ordered) indices of markers in the sequence, according to the input file.}
\item{seq.phases}{a \code{vector} with the linkage phases between markers
in the sequence, in corresponding positions. \code{-1} means that there are
no defined linkage phases.} \item{seq.rf}{a \code{vector} with the
recombination frequencies between markers in the sequence. \code{-1} means
that there are no estimated recombination frequencies.}
\item{seq.like}{log-likelihood of the corresponding linkage map.}
\item{data.name}{object of class \code{onemap} with the raw
data.} \item{twopt}{object of class \code{rf_2pts} with the
2-point analyses.}
}
\description{
Implements the marker ordering algorithm \emph{Unidirectional Growth}
(\cite{Tan & Fu, 2006}).
}
\details{
\emph{Unidirectional Growth} (\emph{UG}) is an algorithm for marker
ordering in linkage groups. It is not an exhaustive search method and,
therefore, is not computationally intensive. However, it does not guarantee
that the best order is always found. The only requirement is a matrix with
recombination fractions between markers.

After determining the order with \emph{UG}, the final map is constructed
using the multipoint approach (function \code{\link[onemap]{map}}).
}
\examples{

\donttest{
  #outcross example
  data(onemap_example_out)
  twopt <- rf_2pts(onemap_example_out)
  all_mark <- make_seq(twopt,"all")
  groups <- group(all_mark)
  LG1 <- make_seq(groups,1)
  LG1.ug <- ug(LG1)

  #F2 example
  data(mapmaker_example_f2)
  twopt <- rf_2pts(mapmaker_example_f2)
  all_mark <- make_seq(twopt,"all")
  groups <- group(all_mark)
  LG1 <- make_seq(groups,1)
  LG1.ug <- ug(LG1)
  LG1.ug
}
}
\references{
Mollinari, M., Margarido, G. R. A., Vencovsky, R. and Garcia,
A. A. F. (2009) Evaluation of algorithms used to order markers on genetics
maps. \emph{Heredity} 103: 494-502.

Tan, Y. and Fu, Y. (2006) A novel method for estimating linkage maps.
\emph{Genetics} 173: 2383-2390.
}
\seealso{
\code{\link[onemap]{make_seq}}, \code{\link[onemap]{map}}
}
\author{
Marcelo Mollinari, \email{mmollina@usp.br}
}
\keyword{utilities}
