% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/milp-linearopt-variables.R
\docType{class}
\name{LinearVariableCollection-class}
\alias{LinearVariableCollection-class}
\alias{LinearVariable-class}
\alias{LinearVariableSum-class}
\alias{*,LinearVariableSum,numeric-method}
\alias{*,numeric,LinearVariableSum-method}
\alias{-,LinearVariableSum,numeric-method}
\alias{-,numeric,LinearVariableSum-method}
\alias{+,LinearVariableSum,LinearVariableSum-method}
\alias{-,LinearVariableSum,LinearVariableSum-method}
\alias{+,LinearVariableSum,LinearVariableCollection-method}
\alias{+,LinearVariableCollection,LinearVariableSum-method}
\alias{-,LinearVariableCollection,LinearVariableSum-method}
\alias{-,LinearVariableSum,LinearVariableCollection-method}
\alias{+,LinearVariableSum,numeric-method}
\alias{+,numeric,LinearVariableSum-method}
\alias{-,LinearVariableSum,missing-method}
\alias{-,LinearVariableCollection,missing-method}
\alias{+,LinearVariableSum,missing-method}
\alias{+,LinearVariableCollection,missing-method}
\alias{+,LinearVariableCollection,numeric-method}
\alias{+,numeric,LinearVariableCollection-method}
\alias{-,LinearVariableCollection,numeric-method}
\alias{-,numeric,LinearVariableCollection-method}
\alias{/,LinearVariableCollection,numeric-method}
\alias{/,LinearVariableSum,numeric-method}
\alias{+,LinearVariableCollection,LinearVariableCollection-method}
\alias{-,LinearVariableCollection,LinearVariableCollection-method}
\alias{*,LinearVariableCollection,numeric-method}
\alias{*,numeric,LinearVariableCollection-method}
\alias{[,LinearVariableCollection,ANY,ANY,missing-method}
\title{An S4 class that represents a collection of variables}
\usage{
\S4method{*}{LinearVariableSum,numeric}(e1, e2)

\S4method{*}{numeric,LinearVariableSum}(e1, e2)

\S4method{-}{LinearVariableSum,numeric}(e1, e2)

\S4method{-}{numeric,LinearVariableSum}(e1, e2)

\S4method{+}{LinearVariableSum,LinearVariableSum}(e1, e2)

\S4method{-}{LinearVariableSum,LinearVariableSum}(e1, e2)

\S4method{+}{LinearVariableSum,LinearVariableCollection}(e1, e2)

\S4method{+}{LinearVariableCollection,LinearVariableSum}(e1, e2)

\S4method{-}{LinearVariableCollection,LinearVariableSum}(e1, e2)

\S4method{-}{LinearVariableSum,LinearVariableCollection}(e1, e2)

\S4method{+}{LinearVariableSum,numeric}(e1, e2)

\S4method{+}{numeric,LinearVariableSum}(e1, e2)

\S4method{-}{LinearVariableSum,missing}(e1, e2)

\S4method{-}{LinearVariableCollection,missing}(e1, e2)

\S4method{+}{LinearVariableSum,missing}(e1, e2)

\S4method{+}{LinearVariableCollection,missing}(e1, e2)

\S4method{+}{LinearVariableCollection,numeric}(e1, e2)

\S4method{+}{numeric,LinearVariableCollection}(e1, e2)

\S4method{-}{LinearVariableCollection,numeric}(e1, e2)

\S4method{-}{numeric,LinearVariableCollection}(e1, e2)

\S4method{/}{LinearVariableCollection,numeric}(e1, e2)

\S4method{/}{LinearVariableSum,numeric}(e1, e2)

\S4method{+}{LinearVariableCollection,LinearVariableCollection}(e1, e2)

\S4method{-}{LinearVariableCollection,LinearVariableCollection}(e1, e2)

\S4method{*}{LinearVariableCollection,numeric}(e1, e2)

\S4method{*}{numeric,LinearVariableCollection}(e1, e2)

\S4method{[}{LinearVariableCollection,ANY,ANY,missing}(x, i, j, ..., drop = TRUE)
}
\arguments{
\item{e1}{a numeric value}

\item{e2}{an object of type 'LinearVariableCollection'}

\item{x}{an object of type 'LinearVariableCollection'}

\item{i}{a numeric vector or a colwise vector/list}

\item{j}{a numeric vector or a colwise vector/list}

\item{...}{more a numeric vectors or a colwise vector/list}

\item{drop}{do not use this parameter}
}
\value{
Returns an object of type 'LinearVariableSum'

Returns an object of type 'LinearVariableSum'

Returns an object of type 'LinearVariableSum'

an object of type 'LinearVariableSum'

a new object of type 'LinearVariableCollection'
}
\description{
It will multiply the numeric vector with both the constant and the variable in
'LinearVariableSum'

It will multiply the numeric vector with both the constant and the variable in
'LinearVariableSum'

Equivalent to `e1 + -1 * e2`

Equivalent to `(-1 * e2) - (-1 * e1)`

Add two object of 'LinearVariableSum'. I.e. variables + constants

Equivalent to `e1 + (-1) * e2`

Adds the variables in the rhs to the variables in the lhs and returns another 'LinearVariableSum'.

Equivalent to `e2 + e1`

Equivalent to `-1 * (e2 - e1)`

Equivalent to `e1 + -1 * e2`

Adds a constant (rhs) to constant slot of the lhs object.

Equivalent to `e2 + e1`

Equivalent to `e1 * (-1)`

Equivalent to `e1 * (-1)`

Equivalent to `e1`

Equivalent to `e1`

Adds a constant numeric vector to a variable. The constant needs to be a vector of length 1.

Equivalent to `e2 + e1`

Equivalent to `e1 + -1 * e2`

Equivalent to `(-1 * e2) - (-1 * e1)`

Equivalent to `e1 * (1 / e2)`

Equivalent to `e1 * (1 / e2)`

Adds two variables together. Same values for variable, row and col will be added. Everything else merged.

Equivalent to `e1 + -1 * e2`

Multiplies the coefficients rowwise with a given numeric vector.
If the numeric vector is a `linear_transposed_vector`, it will multiply the vector
with each variable per row.

Equivalent to `e2 * e1`

This creates a new variable collection as a subset of the previously defined indexed variable.
A variable collection essentially is a data frame having values for rows and columns of the final model matrix.
}
\section{Slots}{

\describe{
\item{\code{variables}}{a data frame hold the variable coefficients. One line for reach variable, row and column.}

\item{\code{index_mapping}}{a function that takes a variable name as character and returns a mapping table that maps column ids to variable indexes.}

\item{\code{variable}}{a linear variable collection with just one index '1'}

\item{\code{constant}}{a numeric vector}

\item{\code{variables}}{a variable collection}
}}

\examples{
\dontrun{
# vectors create matrix rows
# x[1, 1]
# x[2, 1]
# x[3, 1]
x[1:3, 1]

# colwise() creates columns per row
# 1 * x[1, 1] + 2 * x[1, 2] + 3 * x[1, 3]
colwise(1, 2, 3) * x[1, colwise(1, 2, 3)]

# you can also combine the two
# x[1, 1]
# x[2, 1] + x[2, 2]
# x[3, 1] + x[3, 2] + x[3, 2]
x[1:3, colwise(1, 1:2, 1:3)]
}
}
\keyword{internal}
