% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-api.R
\name{variable_bounds}
\alias{variable_bounds}
\title{Variable lower and upper bounds of a model}
\usage{
variable_bounds(model)
}
\arguments{
\item{model}{the model}
}
\value{
a list with two components 'lower' and 'upper' each
having a numeric vector of bounds. One for each variable.
}
\description{
Variable lower and upper bounds of a model
}
\examples{
library(magrittr)
model <- MIPModel() \%>\%
  add_variable(x, type = "binary") \%>\%
  add_variable(y, type = "continuous", lb = 2) \%>\%
  add_variable(z, type = "integer", ub = 3)
variable_bounds(model)
}
