% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger.R
\name{summariseLogFile}
\alias{summariseLogFile}
\title{Summarise and extract the information of a log file into a
\code{summarised_result} object.}
\usage{
summariseLogFile(
  logFile = getOption("omopgenerics.logFile"),
  cdmName = "unknown"
)
}
\arguments{
\item{logFile}{File path to the log file to summarise. Create a logFile with
\code{createLogFile()}.}

\item{cdmName}{Name of the cdm for the \code{summarise_result} object.}
}
\value{
A \code{summarise_result} with the information of the log file.
}
\description{
Summarise and extract the information of a log file into a
\code{summarised_result} object.
}
\examples{
library(dplyr)

logFile <- tempfile(pattern = "log_{date}_{time}", fileext = ".txt")
createLogFile(logFile = logFile)

logMessage("Starting analysis")
1 + 1
logMessage("Analysis finished")

res <- summariseLogFile()

glimpse(res)

tidy(res)

}
