% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.oem}
\alias{plot.oem}
\alias{plot.cv.oem}
\alias{plot.xval.oem}
\title{Plot method for Orthogonalizing EM fitted objects}
\usage{
\method{plot}{oem}(x, which.model = 1, xvar = c("norm", "lambda",
  "loglambda", "dev"), labsize = 0.6, xlab = iname, ylab = NULL,
  main = x$penalty[which.model], ...)

\method{plot}{cv.oem}(x, which.model = 1, sign.lambda = 1, ...)

\method{plot}{xval.oem}(x, which.model = 1, type = c("cv",
  "coefficients"), xvar = c("norm", "lambda", "loglambda", "dev"),
  labsize = 0.6, xlab = iname, ylab = NULL,
  main = x$penalty[which.model], sign.lambda = 1, ...)
}
\arguments{
\item{x}{fitted "oem" model object}

\item{which.model}{If multiple penalties are fit and returned in the same oem object, the which.model argument is used to 
specify which model to plot. For example, if the oem object \code{"oemobj"} was fit with argument 
\code{penalty = c("lasso", "grp.lasso")}, then \code{which.model = 2} provides a plot for the group lasso model.}

\item{xvar}{What is on the X-axis. \code{"norm"} plots against the L1-norm of the coefficients, \code{"lambda"} against the log-lambda sequence, and \code{"dev"}
against the percent deviance explained.}

\item{labsize}{size of labels for variable names. If labsize = 0, then no variable names will be plotted}

\item{xlab}{label for x-axis}

\item{ylab}{label for y-axis}

\item{main}{main title for plot}

\item{...}{other graphical parameters for the plot}

\item{sign.lambda}{Either plot against log(lambda) (default) or its negative if \code{sign.lambda = -1}.}

\item{type}{one of \code{"cv"} or \code{"coefficients"}. \code{type = "cv"} will produce a plot of cross validation results like plot.cv.oem. 
\code{type = "coefficients"} will produce a coefficient path plot like \code{plot.oem()}}
}
\description{
Plot method for Orthogonalizing EM fitted objects

Plot method for Orthogonalizing EM fitted objects
}
\examples{
set.seed(123)
n.obs <- 1e4
n.vars <- 100
n.obs.test <- 1e3

true.beta <- c(runif(15, -0.5, 0.5), rep(0, n.vars - 15))

x <- matrix(rnorm(n.obs * n.vars), n.obs, n.vars)
y <- rnorm(n.obs, sd = 3) + x \%*\% true.beta

fit <- oem(x = x, y = y, penalty = c("lasso", "grp.lasso"), groups = rep(1:10, each = 10))

layout(matrix(1:2, ncol = 2))
plot(fit, which.model = 1)
plot(fit, which.model = 2)

set.seed(123)
n.obs <- 1e4
n.vars <- 100
n.obs.test <- 1e3

true.beta <- c(runif(15, -0.5, 0.5), rep(0, n.vars - 15))

x <- matrix(rnorm(n.obs * n.vars), n.obs, n.vars)
y <- rnorm(n.obs, sd = 3) + x \%*\% true.beta

fit <- cv.oem(x = x, y = y, penalty = c("lasso", "grp.lasso"), groups = rep(1:10, each = 10))

layout(matrix(1:2, ncol = 2))
plot(fit, which.model = 1)
plot(fit, which.model = "grp.lasso")

set.seed(123)
n.obs <- 1e4
n.vars <- 100
n.obs.test <- 1e3

true.beta <- c(runif(15, -0.5, 0.5), rep(0, n.vars - 15))

x <- matrix(rnorm(n.obs * n.vars), n.obs, n.vars)
y <- rnorm(n.obs, sd = 3) + x \%*\% true.beta

fit <- xval.oem(x = x, y = y, penalty = c("lasso", "grp.lasso"), groups = rep(1:10, each = 10))

layout(matrix(1:4, ncol = 2))
plot(fit, which.model = 1)
plot(fit, which.model = 2)

plot(fit, which.model = 1, type = "coef")
plot(fit, which.model = 2, type = "coef")

}
