% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hidden_markov.R
\name{simulate_hmm}
\alias{simulate_hmm}
\title{Simulate HMM data}
\usage{
simulate_hmm(Tp, states, sdd, ...)
}
\arguments{
\item{Tp}{An \code{integer}, the number of observations.}

\item{states}{An \code{integer}, the number of states.}

\item{sdd}{A \code{character}, defining the type of state-dependent distribution.
Print \code{sdds_dictionary} for possible values.}

\item{...}{Currently not used.}
}
\value{
A \code{list} with three elements:
\itemize{
\item \code{"data"} (the simulated time series)
\item \code{"states"} (the simulated states)
\item \code{"parameter"} (the model parameters)
}
}
\description{
This function simulates a times series of a hidden Markov model.
}
\examples{
x <- simulate_hmm(
  Tp = 100, states = 2, sdd = "normal", mean = c(-1, 1), sd = c(1, 1)
)
str(x)
plot(x$data, col = x$states, type = "h")

}
