% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.1.R
\name{power.1}
\alias{power.1}
\title{Budget and/or sample size, power, MDES calculation for
 single-level experiments detecting main effects}
\usage{
power.1(
  cost.model = TRUE,
  expr = NULL,
  constraint = NULL,
  sig.level = 0.05,
  two.tailed = TRUE,
  d = NULL,
  power = NULL,
  m = NULL,
  n = NULL,
  p = NULL,
  r12 = NULL,
  q = NULL,
  c1 = NULL,
  c1t = NULL,
  dlim = NULL,
  powerlim = NULL,
  nlim = NULL,
  mlim = NULL,
  rounded = TRUE
)
}
\arguments{
\item{cost.model}{Logical; power analyses accommodating costs and budget
(e.g., required budget for desired power, power/MDES under fixed budget)
if TRUE, otherwise conventional power analyses
(e.g., required sample size, power, or MDES calculation); default value is TRUE.}

\item{expr}{Returned object from function \code{\link{od.1}}; default value is NULL;
if \code{expr} is specified, parameter values of \code{r12},
\code{c1}, \code{c1t}, and \code{p}
used or solved in function \code{\link{od.1}} will
be passed to the current function;
only the value of \code{p} that specified or solved in
function \code{\link{od.1}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{Specify the constrained value of
\code{p} in list format to overwrite that
from \code{expr}; default value is NULL.}

\item{sig.level}{Significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{Logical; two-tailed tests if TRUE,
otherwise one-tailed tests; default value is TRUE.}

\item{d}{Effect size.}

\item{power}{Statistical power.}

\item{m}{Total budget.}

\item{n}{The total sample size.}

\item{p}{The proportion of individuals to be assigned to treatment.}

\item{r12}{The proportion of outcome variance explained by covariates.}

\item{q}{The number of covariates.}

\item{c1}{The cost of sampling one unit in control condition.}

\item{c1t}{The cost of sampling one unit in treatment condition.}

\item{dlim}{The range for solving the root of effect size (\code{d}) numerically,
default value is c(0, 5).}

\item{powerlim}{The range for solving the root of power (\code{power}) numerically,
default value is c(1e-10, 1 - 1e-10).}

\item{nlim}{The range for searching the root of sample size (\code{n}) numerically,
default value is c(4, 10e10).}

\item{mlim}{The range for searching the root of budget (\code{m}) numerically,
default value is the costs sampling \code{nlim} units across treatment conditions
or c(4 * ncost, 10e10 * ncost) with ncost = ((1 - p) * c1 + p * c1t).}

\item{rounded}{Logical; round \code{p} that is from functions \code{od.1}
to two decimal places if TRUE,
otherwise no rounding; default value is TRUE.}
}
\value{
Required budget (or required sample size), statistical power, or MDES
    depending on the specification of parameters.
    The function also returns the function name, design type,
    and parameters used in the calculation.
}
\description{
This function can calculate required budget for desired power,
    power or minimum detectable effect size (MDES) under fixed budget
    for  single-level experiments.
    It also can perform conventional power analyses
    (e.g., required sample size, power, and MDES calculation).
}
\examples{
# Unconstrained optimal design
  myod1 <- od.1(r12 = 0.5, c1 = 1, c1t = 5, varlim = c(0, 0.2))
  myod1$out   # p = 0.31

# ------- Power analyses by default considering costs and budget -------
# Required budget and sample size
  mym.1 <- power.1(expr = myod1, d = 0.2, q = 1, power = 0.8)
  mym.1$out  # m = 1032 n = 461
  # mym.1$par  # parameters and their values used for the function
# Or, equivalently, specify every argument in the function
  mym.1 <- power.1(d = 0.2, power = 0.8, c1 = 1, c1t = 5,
                  r12 = 0.5, p = 0.31, q = 1)
# Required budget and sample size with constrained p
  mym.2 <- power.1(expr = myod1, d = 0.2, q = 1, power = 0.8,
               constraint = list(p = 0.5))
  mym.2$out  # m = 1183, n = 394

# Power calculation
  mypower <- power.1(expr = myod1, q = 1, d = 0.2, m = 1032)
  mypower$out  # power = 0.80
# Power calculation under constrained p (p = 0.5)
  mypower.1 <- power.1(expr = myod1, q = 1, d = 0.2, m = 1032,
               constraint = list(p = 0.5))
  mypower.1$out  # power = 0.74

# MDES calculation
  mymdes <- power.1(expr = myod1, q = 1, power = 0.80, m = 1032)
  mymdes$out  # d = 0.20


# ------- Conventional power analyses with cost.model = FALSE-------
# Required sample size n
  myn <- power.1(cost.model = FALSE, expr = myod1, d = 0.2, q = 1, power = 0.8)
  myn$out  # n = 461
  # myn$par  # parameters and their values used for the function
# Or, equivalently, specify every argument in the function
  myn <- power.1(cost.model = FALSE, d = 0.2, power = 0.8,
                  r12 = 0.5, p = 0.31, q = 1)

# Power calculation
  mypower1 <- power.1(cost.model = FALSE, expr = myod1, n = 461, d = 0.2, q = 1)
  mypower1$out  # power = 0.80

# MDES calculation
  mymdes1 <- power.1(cost.model = FALSE, expr = myod1, n = 461, power = 0.8, q = 1)
  mymdes1$out  # d = 0.20

}
