% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power.4.R
\name{power.4}
\alias{power.4}
\title{Budget and/or sample size, power, MDES calculation for
four-level CRTs detecting main effects}
\usage{
power.4(
  cost.model = TRUE,
  expr = NULL,
  constraint = NULL,
  sig.level = 0.05,
  two.tailed = TRUE,
  d = NULL,
  power = NULL,
  m = NULL,
  n = NULL,
  J = NULL,
  K = NULL,
  L = NULL,
  p = NULL,
  icc2 = NULL,
  icc3 = NULL,
  icc4 = NULL,
  r12 = NULL,
  r22 = NULL,
  r32 = NULL,
  r42 = NULL,
  q = NULL,
  c1 = NULL,
  c2 = NULL,
  c3 = NULL,
  c4 = NULL,
  c1t = NULL,
  c2t = NULL,
  c3t = NULL,
  c4t = NULL,
  dlim = NULL,
  powerlim = NULL,
  Llim = NULL,
  mlim = NULL,
  rounded = TRUE
)
}
\arguments{
\item{cost.model}{Logical; power analyses accommodating costs and budget
(e.g., required budget for desired power, power/MDES under fixed budget)
if TRUE, otherwise conventional power analyses
(e.g., required sample size, power, or MDES calculation); default value is TRUE.}

\item{expr}{Returned objects from function \code{\link{od.4}}; default value is NULL;
if \code{expr} is specified, parameter values of \code{icc2}, \code{icc3}, \code{icc4},
\code{r12}, \code{r22}, \code{r32}, \code{r42},
\code{c1}, \code{c2}, \code{c3}, \code{c4},
\code{c1t}, \code{c2t}, \code{c3t}, \code{c4t}, \code{p}, \code{n}, \code{J}, and \code{K}
used or solved in function \code{\link{od.4}} will
be passed to current function;
only the values of \code{p}, \code{n}, \code{J}, and/or \code{K} that specified or solved in
function \code{\link{od.4}} can be overwritten
if \code{constraint} is specified.}

\item{constraint}{Specify the constrained values of \code{p}, \code{n}, \code{J},
and/or \code{K} in list format to overwrite
those from \code{expr}; default value is NULL.}

\item{sig.level}{Significance level or type I error rate, default value is 0.05.}

\item{two.tailed}{Logical; two-tailed tests if TRUE,
otherwise one-tailed tests; default value is TRUE.}

\item{d}{Effect size.}

\item{power}{Statistical power.}

\item{m}{Total budget.}

\item{n}{The level-1 sample size per level-2 unit.}

\item{J}{The level-2 sample size per level-3 unit.}

\item{K}{The level-3 sample size per level-4 unit.}

\item{L}{The total level-4 sample size.}

\item{p}{The proportion of level-4 clusters/units to be assigned to treatment.}

\item{icc2}{The unconditional intraclass correlation coefficient (ICC) at level 2.}

\item{icc3}{The unconditional intraclass correlation coefficient (ICC) at level 3.}

\item{icc4}{The unconditional intraclass correlation coefficient (ICC) at level 4.}

\item{r12}{The proportion of level-1 variance explained by covariates.}

\item{r22}{The proportion of level-2 variance explained by covariates.}

\item{r32}{The proportion of level-3 variance explained by covariates.}

\item{r42}{The proportion of level-4 variance explained by covariates.}

\item{q}{The number of covariates at level 4.}

\item{c1}{The cost of sampling one level-1 unit in control condition.}

\item{c2}{The cost of sampling one level-2 unit in control condition.}

\item{c3}{The cost of sampling one level-3 unit in control condition.}

\item{c4}{The cost of sampling one level-4 unit in control condition.}

\item{c1t}{The cost of sampling one level-1 unit in treatment condition.}

\item{c2t}{The cost of sampling one level-2 unit in treatment condition.}

\item{c3t}{The cost of sampling one level-3 unit in treatment condition.}

\item{c4t}{The cost of sampling one level-4 unit in treatment condition.}

\item{dlim}{The range for searching the root of effect size (\code{d}) numerically,
default value is c(0, 5).}

\item{powerlim}{The range for searching the root of power (\code{power}) numerically,
default value is c(1e-10, 1 - 1e-10).}

\item{Llim}{The range for searching the root of level-4 sample size (\code{L}) numerically,
default value is c(4, 1e+10).}

\item{mlim}{The range for searching the root of budget (\code{m}) numerically,
default value is the costs sampling \code{Llim} level-4 units across treatment conditions
or c(4 * Lcost, 1e+10 * Lcost) with Lcost =
((1 - p) * (c1 * n * J * K + c2 * J * K + c3 * K + c4) +
p * (c1t * n * J * K + c2t * J * K + c3t * K + c4t)).}

\item{rounded}{Logical; round the values of \code{p}, \code{n}/\code{J}/\code{K}
that are from functions \code{\link{od.4}}
to two decimal places and integer, respectively if TRUE,
otherwise no rounding; default value is TRUE.}
}
\value{
Required budget (and/or required level-4 sample size), statistical power, or MDES
    depending on the specification of parameters.
    The function also returns the function name, design type,
    and parameters used in the calculation.
}
\description{
This function can calculate required budget for desired power,
    power or minimum detectable effect size (MDES) under fixed budget
    for four-level cluster randomized trials (CRTs).
    It also can perform conventional power analyses
    (e.g., required sample size, power, and MDES calculation).
}
\examples{
# Unconstrained optimal design
  myod1 <- od.4(icc2 = 0.2, icc3 = 0.1, icc4 = 0.05,
              r12 = 0.5, r22 = 0.5, r32 = 0.5, r42 = 0.5,
              c1 = 1, c2 = 5, c3 = 25, c4 = 125,
              c1t = 1, c2t = 50, c3t = 250, c4t = 2500)
  myod1$out # output # n = 7.1, J = 3.2, K = 4.2, p = 0.23

# ------- Power analyses by default considering costs and budget -------
# Required budget and sample size
  mym.1 <- power.4(expr = myod1, d = 0.2, q = 1, power = 0.8)
  mym.1$out  # m = 71161, L = 57.1
  #mym.1$par  # parameters and their values used for the function
# Or, equivalently, specify every argument in the function
  mym.1 <- power.4(d = 0.2, power = 0.8, q = 1,
                 icc2 = 0.2, icc3 = 0.1, icc4 = 0.05,
                 r12 = 0.5, r22 = 0.5, r32 = 0.5, r42 = 0.5,
                 c1 = 1, c2 = 5, c3 = 25, c4 = 125,
                 c1t = 1, c2t = 50, c3t = 250, c4t = 2500,
                 n = 7, J = 3, K = 4, p = 0.23)
# Required budget and sample size with constrained p (p = 0.5)
  mym.2 <- power.4(expr = myod1, d = 0.2, q = 1, power = 0.8,
                 constraint = list(p = 0.5))
  mym.2$out  # m = 93508, L = 41.1
# Required budget and sample size with constrained p and K
  mym.3 <- power.4(expr = myod1, d = 0.2, q = 1, power = 0.8,
                 constraint = list(p = 0.5, K = 20))
  mym.3$out  # m = 157365, L = 25.7

# Power calculation
  mypower <- power.4(expr = myod1, q = 1, d = 0.2, m = 71161)
  mypower$out  # power = 0.80
# Power calculation under constrained p (p = 0.5)
  mypower.1 <- power.4(expr = myod1, q = 1, d = 0.2, m = 71161,
                 constraint = list(p = 0.5))
  mypower.1$out  # power = 0.68

# MDES calculation
  mymdes <- power.4(expr = myod1, q = 1, power = 0.80, m = 71161)
  mymdes$out  # d = 0.20


# ------- Conventional power analyses with cost.model = FALSE-------
# Required sample size
  myL <- power.4(cost.model = FALSE, expr = myod1, d = 0.2, q = 1, power = 0.8)
  myL$out  # L = 57.1
#myL$par  # parameters and their values used for the function
# Or, equivalently, specify every argument in the function
  myL <- power.4(cost.model = FALSE, d = 0.2, power = 0.8, q = 1,
                  icc2 = 0.2, icc3 = 0.1, icc4 = 0.05,
                  r12 = 0.5, r22 = 0.5, r32 = 0.5, r42 = 0.5,
                  n = 7, J = 3, K = 4, p = 0.23)

# Power calculation
  mypower1 <- power.4(cost.model = FALSE, expr = myod1, L = 57, d = 0.2, q = 1)
  mypower1$out  # power = 0.80

# MDES calculation
  mymdes1 <- power.4(cost.model = FALSE, expr = myod1, L = 57, power = 0.8, q = 1)
  mymdes1$out  # d = 0.20

}
