% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toa_sports_odds.R
\name{toa_sports_odds}
\alias{toa_sports_odds}
\title{\strong{Find odds for the sports which are accessible through the Odds API}}
\usage{
toa_sports_odds(
  sport_key,
  regions = "us",
  markets = "spreads",
  odds_format = "decimal",
  date_format = "iso"
)
}
\arguments{
\item{sport_key}{The \code{sport_key} to look up odds for. See \code{toa_sports()} for a full lookup of \code{sport_key} values.}

\item{regions}{The region to pull odds from. Options include:
\itemize{
\item us
\item uk
\item us
\item eu
\item au
Multiple can be specified if comma delimited.
}}

\item{markets}{The type of odds to return. Multiple can be specified if comma delimited. Options include:
\itemize{
\item h2h
\item spreads
\item totals
}}

\item{odds_format}{The format in which to return odds. Options include:
\itemize{
\item decimal
\item american
}}

\item{date_format}{Date format. Options include:
\itemize{
\item iso
\item unix
}}
}
\value{
Sports for which The Odds API provides betting information for as a tibble:\tabular{ll}{
   col_name \tab types \cr
   id \tab character \cr
   sport_key \tab character \cr
   sport_title \tab character \cr
   commence_time \tab character \cr
   home_team \tab character \cr
   away_team \tab character \cr
   bookmaker_key \tab character \cr
   bookmaker \tab character \cr
   last_update \tab character \cr
   market_key \tab character \cr
   outcomes_name \tab character \cr
   outcomes_price \tab numeric \cr
   outcomes_point \tab numeric \cr
}
}
\description{
\strong{Get the odds for the sports which the Odds API provides coverage}

\if{html}{\out{<div class="sourceCode r">}}\preformatted{   try(toa_sports_odds(sport_key = 'baseball_mlb', 
                       regions = 'us', 
                       markets = 'spreads', 
                       odds_format = 'decimal',
                       date_format = 'iso'))
}\if{html}{\out{</div>}}
}
\examples{
\donttest{
   try(toa_sports_odds(sport_key = 'basketball_nba', 
                       regions = 'us', 
                       markets = 'spreads', 
                       odds_format = 'decimal',
                       date_format = 'iso'))
}

}
\keyword{Betting}
\keyword{Lines}
