% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/od-funs.R
\name{od_coordinates}
\alias{od_coordinates}
\title{Create matrices representing origin-destination coordinates}
\usage{
od_coordinates(x, p = NULL, silent = TRUE, sfnames = FALSE)
}
\arguments{
\item{x}{A data frame in which the first two columns are codes
representing points/zones of origin and destination}

\item{p}{Points representing origins and destinations}

\item{silent}{Hide messages? \code{FALSE} by default.}

\item{sfnames}{Should output column names be compatible with the sf package?}
}
\value{
A data frame with origin and destination coordinates
}
\description{
This function takes a wide range of input data types (spatial lines, points or text strings)
and returns a data frame of coordinates representing origin (ox, oy) and destination (dx, dy) points.
}
\examples{
x = od_data_df
p = od_data_centroids
res = od_coordinates(x, p)[1:2, ]
class(res)
res
od_coordinates(x, p, sfnames = TRUE)[1:2, ]
od_coordinates(x, p, silent = FALSE)[1:2, ]
}
