% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bin.R
\name{binAverage}
\alias{binAverage}
\title{Bin-average a Vector y, Based on x Values}
\usage{
binAverage(x, y, xmin, xmax, xinc, include.lowest = FALSE, na.rm = FALSE)
}
\arguments{
\item{x}{a vector of numerical values.}

\item{y}{a vector of numerical values.}

\item{xmin}{x value at the lower limit of first bin; the minimum \code{x}
will be used if this is not provided.}

\item{xmax}{x value at the upper limit of last bin; the maximum \code{x}
will be used if this is not provided.}

\item{xinc}{width of bins, in terms of x value; 1/10th of \code{xmax-xmin}
will be used if this is not provided.}

\item{include.lowest}{logical value indicating whether to include
\code{y} values for which the corresponding \code{x} is equal to \code{xmin}.
See \dQuote{Details}.}

\item{na.rm}{logical value indicating whether to remove NA values before
doing the computation of the average. This is passed to \code{\link[=mean]{mean()}}, which
does the work of the present function.}
}
\value{
A list with two elements: \code{x}, the mid-points of the bins, and
\code{y}, the average \code{y} value in the bins.
}
\description{
\code{\link[=binAverage]{binAverage()}} works by calling \code{\link[=binMean1D]{binMean1D()}}, after computing
the \code{xbreaks} parameter of the latter function as \code{seq(xmin,xmax,xinc)}.
Note that the return value of \code{\link[=binAverage]{binAverage()}} uses only the \code{xmids} and
\code{result} entries of the \code{\link[=binMean1D]{binMean1D()}} result.
}
\details{
By default, the sub-intervals defined by \code{xmin}, \code{xinc} and \code{xmax}
arguments are open on the left and closed on the right, to match
the behaviour of \code{\link[=cut]{cut()}}.  An open interval does not include
points on the boundary, and so any \code{x} values that exactly match
the first \code{breaks} value will not be counted.  To include
such points in the calculation, set \code{include.lowest} to TRUE.
}
\examples{
library(oce)
# A. fake linear data
x <- seq(0, 100, 1)
y <- 1 + 2 * x
plot(x, y, pch = 1)
ba <- binAverage(x, y)
points(ba$x, ba$y, pch = 3, col = "red", cex = 3)

# B. fake quadratic data
y <- 1 + x^2
plot(x, y, pch = 1)
ba <- binAverage(x, y)
points(ba$x, ba$y, pch = 3, col = "red", cex = 3)

# C. natural data
data(co2)
plot(co2)
avg <- binAverage(time(co2), co2, 1950, 2000, 2)
points(avg$x, avg$y, col = "red")

}
\seealso{
Other bin-related functions: 
\code{\link{binApply1D}()},
\code{\link{binApply2D}()},
\code{\link{binCount1D}()},
\code{\link{binCount2D}()},
\code{\link{binMean1D}()},
\code{\link{binMean2D}()}
}
\author{
Dan Kelley
}
\concept{bin-related functions}
