% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tides.R
\name{tidemVuf}
\alias{tidemVuf}
\title{Nodal Modulation Calculations for Tidem}
\usage{
tidemVuf(t, j, latitude = NULL)
}
\arguments{
\item{t}{a single time in \code{\link[=POSIXct]{POSIXct()}} format, with timezone \code{"UTC"}.}

\item{j}{integer vector, giving indices of tidal constituents to use.}

\item{latitude}{optional numerical value containing the latitude in degrees North.
If not provided, \code{u} in the return value will be a vector consisting of
repeated 0 value, and \code{f} will be a vector of repeated 1 value.}
}
\value{
A \code{list} containing
items named \code{v}, \code{u} and \code{f} as described in the \code{T_TIDE} documentation,
as well in Pawlowicz et al. (2002) and Foreman (1978).
}
\description{
Carry out nodal modulation calculations for \code{\link[=tidem]{tidem()}}. This function is based directly
on \code{t_vuf} in the \code{T_TIDE} Matlab package (Pawlowicz et al., 2002),
which inherits from the Fortran code described by Foreman (1978).
}
\examples{
## Look up values for the M2 constituent in Halifax Harbour, Canada.
library(oce)
data("tidedata")
j <- with(tidedata$const, which(name=="M2"))
tidemVuf(t=as.POSIXct("2008-01-22 18:50:24"), j=j, lat=44.63)

}
\references{
\itemize{
\item Foreman, M. G. G., 1978. Manual for Tidal Currents Analysis and Prediction.
Pacific Marine Science Report. British Columbia, Canada: Institute of Ocean
Sciences, Patricia Bay.
\item Pawlowicz, Rich, Bob Beardsley, and Steve Lentz, 2002.  Classical tidal
harmonic analysis including error estimates in MATLAB using \code{T_TIDE}.
Computers and Geosciences, 28, 929-937.
}
}
\seealso{
Other things related to tides: 
\code{\link{[[,tidem-method}},
\code{\link{[[<-,tidem-method}},
\code{\link{as.tidem}()},
\code{\link{plot,tidem-method}},
\code{\link{predict.tidem}()},
\code{\link{summary,tidem-method}},
\code{\link{tidalCurrent}},
\code{\link{tidedata}},
\code{\link{tidem-class}},
\code{\link{tidemAstron}()},
\code{\link{tidem}},
\code{\link{webtide}()}
}
\author{
Dan Kelley translated this from the \code{t_vuf} function
of the \code{T_TIDE} Matlab package (see Pawlowicz et al. 2002).
}
\concept{things related to tides}
