% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/argo.R
\name{[[,argo-method}
\alias{[[,argo-method}
\title{Extract Something From an Argo Object}
\usage{
\S4method{[[}{argo}(x, i, j, ...)
}
\arguments{
\item{x}{an \linkS4class{argo} object.}

\item{i}{character value indicating the name of an item to extract.}

\item{j}{optional additional information on the \code{i} item.}

\item{...}{ignored.}
}
\description{
Generally, the \code{[[} method lets users extract information from \code{oce}
objects, without having to know the details of the internal storage.  For
many \code{oce} sub-classes, \code{[[} can also return quantities that are computed
from the object's contents.
}
\details{
A two-step process is used to try to find the requested information. First, a
class-specific function is used (see \dQuote{Details of the Specialized
Method}).  If this yields nothing, then a general method is used (see
\dQuote{Details of the General Method}).  If both methods fail, then \code{[[}
returns NULL.

Some understanding of the subclass is required to know what can be retrieved
with \code{[[}. When dealing with an unfamiliar subclass, it can be useful to
first use \code{x[["?"]]} to get a listing of the retrievable items. See
\dQuote{Details of the Specialized Method} for more information.
}
\section{Details of the Specialized Method}{


Note that \linkS4class{argo} data may contain both unadjusted data and adjusted
data.  By default, this extraction function refers to the former, but a
preference for the latter may be set with \code{\link[=preferAdjusted]{preferAdjusted()}}, the
documentation of which explains (fairly complex) details.

The results from \code{argo[[i]]} or \code{argo[[i,j]]} depend on the
nature of \code{i} and (if provided) \code{j}. The details are as follows.
\itemize{
\item If \code{i} is \code{"?"}, then the return value is a list
containing four items, each of which is a character vector
holding the names of things that can be accessed with \code{[[}.
The \code{data} and \code{metadata} items hold the names of
entries in the object's data and metadata
slots, respectively. The \code{dataDerived}
and \code{metadataDerived} items hold the names of things
that can be inferred from the object's contents, e.g.
\code{"SA"} is named in \code{dataDerived}, indicating that
\code{argo[["SA"]]} is permitted (to compute Absolute Salinity).
\item If \code{i} is \code{"profile"} and \code{j} is an integer vector,
then an argo object is returned, as specified by \code{j}. For example,
\code{argo[["profile", 2:5]]} is equivalent to
\code{subset(argo, profile \%in\% 2:5)}.
\item If \code{i} is \code{"CT"}, then
Conservative Temperature is returned, as computed with
\code{\link[gsw:gsw_CT_from_t]{gsw::gsw_CT_from_t}}\verb{(SA,t,p)}, where
first \code{SA} is computed as explained
in the next item, \code{t} is in-situ temperature,
and \code{p} is pressure.
\item If \code{i} is \code{"N2"}, then the square of buoyancy is returned,
as computed with \code{\link[=swN2]{swN2()}}.
\item If \code{i} is \code{"SA"}, then
Absolute Salinity is returned, as computed with
\code{\link[gsw:gsw_SA_from_SP]{gsw::gsw_SA_from_SP()}}.
\item If \code{i} is \code{"sigmaTheta"}, then
potential density anomaly (referenced to zero
pressure) is computed, with \code{\link[=swSigmaTheta]{swSigmaTheta()}}, where the
equation of state is taken to be
\code{\link{getOption}}\verb{("oceEOS",default="gsw")}.
\item If \code{i} is \code{"sigma0"}, \code{"sigma1"}, \code{"sigma2"}, \code{"sigma3"} or \code{"sigma4"},
then the associated function in the \CRANpkg{gsw} package.
For example, \code{"sigma0"} uses \code{\link[gsw:gsw_sigma0]{gsw::gsw_sigma0()}}, which returns
potential density anomaly referenced to 0 dbar,
according to the gsw equation of state.
\item If \code{i} is \code{"theta"}, then
potential temperature (referenced to zero
pressure) is computed, with \code{\link[=swTheta]{swTheta()}}, where the
equation of state is taken to be
\code{\link{getOption}}\verb{("oceEOS",default="gsw")}.
\item If \code{i} is \code{"depth"}, then
a matrix of depths is returned.
\item If \code{i} is \code{"id"} or \code{"ID"}, then the \code{id} element within
the \code{metadata} slot is returned.
\item If \code{i} is in the \code{data} slot of \code{x},
then it is returned, otherwise if it is in the \code{metadata} slot,
then that is returned, otherwise \code{NULL} is returned.
}
}

\section{Details of the General Method}{


Note: the text of this section is identical for all \code{oce} subclasses, and so
some of what you read here may not be relevant to the class being described
in this help page.

If the specialized method produces no matches, the following generalized
method is applied. As with the specialized method, the procedure hinges first
on the values of \code{i} and, optionally, \code{j}. The work proceeds in steps, by
testing a sequence of possible conditions in sequence.
\enumerate{
\item A check is made as to whether \code{i} names one of the standard \code{oce} slots.
If so, \code{[[} returns the slot contents of that slot.  Thus, \code{x[["metadata"]]}
will retrieve the \code{metadata} slot, while \code{x[["data"]]} and
\code{x[["processingLog"]]} return those slots.
\item If \code{i} is a string ending in the \code{"Unit"}, then the characters preceding
that string are taken to be the name of an item in the data object, and a
list containing the unit is returned (or \code{NULL} if there is no such unit).
This list consists of an item named \code{unit}, which is an \code{\link[=expression]{expression()}}, and
an item named \code{scale}, which is a string describing the measurement scale.
If the string ends in \code{" unit"}, e.g.  \code{x[["temperature unit"]]} (note the
space), then just the expression is returned, and if it ends in \code{" scale"},
then just the scale is returned.
\item If \code{i} is a string ending in \code{"Flag"}, then the corresponding data-quality
flag is returned (or \code{NULL} if there is no such flag).
\item If the object holds hydrographic information (pressure, salinity,
temperature, longitude and latitude) then another set of possibilities
arises.  If \code{i} is \code{"sigmaTheta"}, then the value of \code{\link[=swSigmaTheta]{swSigmaTheta()}} is
called with \code{x} as the sole argument, and the results are returned.
Similarly, \code{\link[=swSigma0]{swSigma0()}} is used if \code{i="sigma0"}, and \code{\link[=swSpice]{swSpice()}} is used if
\code{i="spice"}. Of course, these actions only make sense for objects that
contain the relevant items within their \code{data} slot.
\item After these possibilities are eliminated, the action depends on whether
\code{j} has been provided.  If \code{j} is not provided, or is the string \code{""}, then
\code{i} is sought in the \code{metadata} slot, and then in the \code{data} slot, returning
whichever is found first.  In other words, if \code{j} is not provided, the
\code{metadata} slot takes preference over the \code{data} slot. However, if \code{j} is
provided, then it must be either the string \code{"metadata"} or \code{"data"}, and it
directs where to look.
\item If none of the above-listed conditions holds, then \code{NULL} is returned.
}
}

\examples{
data(argo)
# 1. show that dataset has 223 profiles, each with 56 levels
dim(argo[['temperature']])

# 2. show importance of focussing on data flagged 'good'
fivenum(argo[["salinity"]],na.rm=TRUE)
fivenum(argo[["salinity"]][argo[["salinityFlag"]]==1],na.rm=TRUE)

}
\seealso{
Other functions that extract parts of oce objects: 
\code{\link{[[,adp-method}},
\code{\link{[[,adv-method}},
\code{\link{[[,amsr-method}},
\code{\link{[[,bremen-method}},
\code{\link{[[,cm-method}},
\code{\link{[[,coastline-method}},
\code{\link{[[,ctd-method}},
\code{\link{[[,echosounder-method}},
\code{\link{[[,g1sst-method}},
\code{\link{[[,gps-method}},
\code{\link{[[,ladp-method}},
\code{\link{[[,landsat-method}},
\code{\link{[[,lisst-method}},
\code{\link{[[,lobo-method}},
\code{\link{[[,met-method}},
\code{\link{[[,oce-method}},
\code{\link{[[,odf-method}},
\code{\link{[[,rsk-method}},
\code{\link{[[,sealevel-method}},
\code{\link{[[,section-method}},
\code{\link{[[,tidem-method}},
\code{\link{[[,topo-method}},
\code{\link{[[,windrose-method}},
\code{\link{[[,xbt-method}},
\code{\link{[[<-,adv-method}}

Other things related to argo data: 
\code{\link{[[<-,argo-method}},
\code{\link{argo-class}},
\code{\link{argoGrid}()},
\code{\link{argoNames2oceNames}()},
\code{\link{argo}},
\code{\link{as.argo}()},
\code{\link{handleFlags,argo-method}},
\code{\link{plot,argo-method}},
\code{\link{read.argo}()},
\code{\link{subset,argo-method}},
\code{\link{summary,argo-method}}
}
\author{
Dan Kelley
}
\concept{functions that extract parts of oce objects}
\concept{things related to argo data}
