% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/odf.R
\docType{class}
\name{odf-class}
\alias{odf-class}
\title{Class to Store ODF Data}
\description{
This class is for data stored in a format used at Canadian
Department of Fisheries and Oceans laboratories. It is somewhat
similar to the \linkS4class{bremen} class, in the sense
that it does not apply just to a particular instrument.
}
\section{Slots}{

\describe{
\item{\code{data}}{As with all \code{oce} objects, the \code{data} slot
for \code{odf} objects is a
\link{list} containing the main data for the object.
{}}

\item{\code{metadata}}{As with all \code{oce} objects, the \code{metadata} slot
for \code{odf} objects is a \link{list} containing
information about the \code{data} or about the object itself.
{}}

\item{\code{processingLog}}{As with all \code{oce} objects, the \code{processingLog} slot
for \code{odf} objects is a
\link{list} with entries describing the creation and evolution
of the object. The contents are updated by various \code{oce} functions to
keep a record of processing steps.  Object summaries and
\code{\link[=processingLogShow]{processingLogShow()}} both display the log.}
}}

\section{Modifying slot contents}{


Although the \code{[[<-} operator may permit modification of the contents
of \linkS4class{odf} objects (see \code{\link{[[<-,odf-method}}),
it is better to use \code{\link[=oceSetData]{oceSetData()}} and \code{\link[=oceSetMetadata]{oceSetMetadata()}},
because those functions save an entry in the \code{processingLog}
that describes the change.
}

\section{Retrieving slot contents}{


The full contents of the \code{data} and \code{metadata} slots of a \linkS4class{odf}
object may be retrieved in the standard R way using \code{\link[=slot]{slot()}}. For
example \code{slot(o,"data")} returns the \code{data} slot of an object named \code{o},
and similarly \code{slot(o,"metadata")} returns
the \code{metadata} slot.

The slots may also be obtained with the \code{\link{[[,odf-method}}
operator, as e.g. \code{o[["data"]]} and \code{o[["metadata"]]}, respectively.

The \code{\link{[[,odf-method}} operator can also
be used to retrieve items from within the \code{data} and \code{metadata} slots.
For example, \code{o[["temperature"]]} can be used to retrieve temperature
from an object containing that quantity. The rule is that a named
quantity is sought first within the object's \code{metadata} slot,
with the \code{data} slot being checked only if \code{metadata} does not
contain the item. This \code{[[} method can also be used to get
certain derived quantities, if the object contains sufficient
information to calculate them. For example, an object that holds
(practical) salinity, temperature and pressure, along with
longitude and latitude, has sufficient information to compute
Absolute Salinity, and so \code{o[["SA"]]} will yield the
calculated Absolute Salinity.

It is also possible to find items more directly, using \code{\link[=oceGetData]{oceGetData()}} and
\code{\link[=oceGetMetadata]{oceGetMetadata()}}, but neither of these functions can
retrieve derived items.
}

\references{
\enumerate{
\item Anthony W. Isenor and David Kellow, 2011. \emph{ODF Format Specification
Version 2.0}. (This is a .doc file obtained in June 2011 by Dan Kelley,
which no longer seems to be made available at any DFO website.)
\item (Unknown authors), October 2014. \emph{ODF Format Description (MLI)},
\url{https://ogsl.ca/wp-content/uploads/ODF_format_desc_en_0.pdf},
(Link verified on May 1, 2021.)
\item A sample ODF file in the DFO format is available at
\code{system.file("extdata","CTD_BCD2014666_008_1_DN.ODF.gz",package="oce")}
\item A sample ODF file in the MLI format is available at
\url{https://ogsl.ca/wp-content/uploads/ODF_file_example_en_0.pdf}.
(Link verified on May 1, 2021.)
}
}
\seealso{
Other things related to odf data: 
\code{\link{CTD_BCD2014666_008_1_DN.ODF.gz}},
\code{\link{ODF2oce}()},
\code{\link{ODFListFromHeader}()},
\code{\link{ODFNames2oceNames}()},
\code{\link{[[,odf-method}},
\code{\link{[[<-,odf-method}},
\code{\link{plot,odf-method}},
\code{\link{read.ctd.odf}()},
\code{\link{read.odf}()},
\code{\link{subset,odf-method}},
\code{\link{summary,odf-method}}

Other classes provided by oce: 
\code{\link{adp-class}},
\code{\link{adv-class}},
\code{\link{argo-class}},
\code{\link{bremen-class}},
\code{\link{cm-class}},
\code{\link{coastline-class}},
\code{\link{ctd-class}},
\code{\link{lisst-class}},
\code{\link{lobo-class}},
\code{\link{met-class}},
\code{\link{oce-class}},
\code{\link{rsk-class}},
\code{\link{sealevel-class}},
\code{\link{section-class}},
\code{\link{topo-class}},
\code{\link{windrose-class}},
\code{\link{xbt-class}}
}
\author{
Dan Kelley
}
\concept{classes provided by oce}
\concept{things related to odf data}
