% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sw.R
\name{swZ}
\alias{swZ}
\title{Vertical coordinate}
\usage{
swZ(pressure, latitude = 45, eos = getOption("oceEOS", default = "gsw"))
}
\arguments{
\item{pressure}{either pressure (dbar), in which case \code{lat} must also
be given, or a \code{ctd} object, in which case \code{lat} will be inferred
from the object.}

\item{latitude}{Latitude in \eqn{^\circ}{deg}N or radians north of the
equator.}

\item{eos}{indication of formulation to be used, either \code{"unesco"} or
\code{"gsw"}.}
}
\description{
Compute height above the surface. This is the negative of depth,
and so is defined simply in terms of \code{\link[=swDepth]{swDepth()}}.
}
\seealso{
Other functions that calculate seawater properties: 
\code{\link{T68fromT90}()},
\code{\link{T90fromT48}()},
\code{\link{T90fromT68}()},
\code{\link{swAbsoluteSalinity}()},
\code{\link{swAlphaOverBeta}()},
\code{\link{swAlpha}()},
\code{\link{swBeta}()},
\code{\link{swCSTp}()},
\code{\link{swConservativeTemperature}()},
\code{\link{swDepth}()},
\code{\link{swDynamicHeight}()},
\code{\link{swLapseRate}()},
\code{\link{swN2}()},
\code{\link{swPressure}()},
\code{\link{swRho}()},
\code{\link{swRrho}()},
\code{\link{swSCTp}()},
\code{\link{swSTrho}()},
\code{\link{swSigma0}()},
\code{\link{swSigma1}()},
\code{\link{swSigma2}()},
\code{\link{swSigma3}()},
\code{\link{swSigma4}()},
\code{\link{swSigmaTheta}()},
\code{\link{swSigmaT}()},
\code{\link{swSigma}()},
\code{\link{swSoundAbsorption}()},
\code{\link{swSoundSpeed}()},
\code{\link{swSpecificHeat}()},
\code{\link{swSpice}()},
\code{\link{swTFreeze}()},
\code{\link{swTSrho}()},
\code{\link{swThermalConductivity}()},
\code{\link{swTheta}()},
\code{\link{swViscosity}()}
}
\concept{functions that calculate seawater properties}
