% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ladp.R
\name{as.ladp}
\alias{as.ladp}
\title{Coerce data into an ladp object}
\usage{
as.ladp(longitude, latitude, station, time, pressure, u, v, uz, vz,
  salinity, temperature, ...)
}
\arguments{
\item{longitude}{longitude in degrees east, or an \code{oce} object that
contains the data otherwise given by \code{longitude} and the
other arguments.}

\item{latitude}{latitude in degrees east (use negative in southern hemisphere).}

\item{station}{number or string indicating station ID.}

\item{time}{time at the start of the profile, constructed by e.g. \code{\link{as.POSIXct}}.}

\item{pressure}{pressure in decibars, through the water column.}

\item{u}{eastward velocity (m/s).}

\item{v}{northward velocity (m/s).}

\item{uz}{vertical derivative of eastward velocity (1/s).}

\item{vz}{vertical derivative of northward velocity (1/s).}

\item{salinity}{salinity through the water column, in practical salinity units.}

\item{temperature}{temperature through the water column.}

\item{\dots}{optional additional data columns.}
}
\value{
An object of \code{\link{ladp-class}}.
}
\description{
This function assembles vectors of pressure and velocity, possibly also with
shears, salinity, temperature, etc.
}
\seealso{
Other things related to ladp data: \code{\link{[[,ladp-method}},
  \code{\link{[[<-,ladp-method}}, \code{\link{ladp-class}},
  \code{\link{plot,ladp-method}},
  \code{\link{summary,ladp-method}}
}
\author{
Dan Kelley
}
\concept{things related to ladp data}
