% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/section.R
\name{sectionAddStation}
\alias{sectionAddCtd}
\alias{sectionAddStation}
\title{Add a CTD Station to a Section}
\usage{
sectionAddStation(section, station)
}
\arguments{
\item{section}{A section to which a station is to be added.}

\item{station}{A ctd object holding data for the station to be added.}
}
\value{
An object of \code{\link[base]{class}} \code{section}.
}
\description{
Add a CTD profile to an existing section.
}
\section{Historical note}{

Until March 2015, this operation was carried out with the \code{+} operator,
but at that time, the syntax was flagged by the development version of R, so it
was changed to the present form.
}
\examples{
library(oce)
data(ctd)
ctd2 <- ctd
ctd2[["temperature"]] <- ctd2[["temperature"]] + 0.5
ctd2[["latitude"]] <- ctd2[["latitude"]] + 0.1
section <- as.section(c("ctd", "ctd2"))
ctd3 <- ctd
ctd3[["temperature"]] <- ctd[["temperature"]] + 1
ctd3[["latitude"]] <- ctd[["latitude"]] + 0.1
ctd3[["station"]] <- "Stn 3"
sectionAddStation(section, ctd3)

}
\author{
Dan Kelley
}
\seealso{
Other things related to \code{section} data: \code{\link{[[,section-method}},
  \code{\link{[[<-,section-method}},
  \code{\link{as.section}},
  \code{\link{handleFlags,section-method}},
  \code{\link{plot,section-method}},
  \code{\link{read.section}}, \code{\link{section-class}},
  \code{\link{sectionGrid}}, \code{\link{sectionSmooth}},
  \code{\link{sectionSort}}, \code{\link{section}},
  \code{\link{subset,section-method}},
  \code{\link{summary,section-method}}
}

