% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctd.R
\name{write.ctd}
\alias{write.ctd}
\title{Write a CTD Data Object as a CSV File}
\usage{
write.ctd(object, file = stop("'file' must be specified"))
}
\arguments{
\item{object}{A \code{ctd} object, i.e. one inheriting from \code{\link{ctd-class}}.}

\item{file}{Either a character string (the file name) or a connection.  This is
a mandatory argument.}
}
\description{
Writes a comma-separated file containing the data frame stored in
the \code{data} slot of the first argument.  The file is suitable
for reading with a spreadsheet, or
with \code{\link{read.csv}}.  Note that the output file will retain none of the
meta-data stored in \code{object}.
}
\examples{
\dontrun{
library(oce)
data(ctd)
write.ctd(ctd, "ctd.csv")
d <- read.csv("ctd.csv")
plot(as.ctd(d$salinity, d$temperature, d$pressure))
} 

}
\author{
Dan Kelley
}
\seealso{
The documentation for \code{\link{ctd-class}} explains the structure
of CTD objects, and also outlines the other functions dealing with them.

Other things related to \code{ctd} data: \code{\link{[[,ctd-method}},
  \code{\link{[[<-,ctd-method}}, \code{\link{as.ctd}},
  \code{\link{cnvName2oceName}}, \code{\link{ctd-class}},
  \code{\link{ctdAddColumn}}, \code{\link{ctdDecimate}},
  \code{\link{ctdFindProfiles}}, \code{\link{ctdRaw}},
  \code{\link{ctdTrim}}, \code{\link{ctdUpdateHeader}},
  \code{\link{ctd}}, \code{\link{gps-class}},
  \code{\link{handleFlags,ctd-method}},
  \code{\link{plot,ctd-method}}, \code{\link{plotProfile}},
  \code{\link{plotScan}}, \code{\link{plotTS}},
  \code{\link{read.ctd.itp}}, \code{\link{read.ctd.odf}},
  \code{\link{read.ctd.sbe}},
  \code{\link{read.ctd.woce.other}},
  \code{\link{read.ctd.woce}}, \code{\link{read.ctd}},
  \code{\link{subset,ctd-method}},
  \code{\link{summary,ctd-method}},
  \code{\link{woceNames2oceNames}}
}

