% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g1sst.R
\docType{class}
\name{g1sst-class}
\alias{g1sst-class}
\title{Class to hold G1SST satellite-model data}
\description{
G1SST is an acronym for global 1-km sea surface temperature, a product
that combines satellite data with the model output. It is provided by
the JPO ROMS (Regional Ocean Modelling System) modelling group.
See the JPL website [1] to learn more about the data, and see
the \code{\link{read.g1sst}} documentation for an example
of downloading and plotting.
}
\details{
It is important not to regard G1SST data in the same category as,
say, \code{\link{amsr-class}} data, because the two products
differ greatly with respect to cloud cover. The satellite used by
\code{\link{amsr-class}} has the ability to sense water temperature
even if there is cloud cover, whereas \code{g1sst} fills in cloud
gaps with model simulations.  It can be helpful to consult 
[1] for a given time, clicking and then unclicking the radio button
that turns off the model-based filling of cloud gaps.
}
\author{
Dan Kelley
}
\references{
1. JPO OurOcean Portal \url{http://ourocean.jpl.nasa.gov/SST/}
}
\seealso{
Other functions dealing with satellite data: \code{\link{[[,landsat-method}},
  \code{\link{amsr-class}}, \code{\link{landsatAdd}},
  \code{\link{landsatTrim}},
  \code{\link{plot,amsr-method}},
  \code{\link{plot,landsat-method}},
  \code{\link{plot,satellite-method}},
  \code{\link{read.amsr}}, \code{\link{read.g1sst}},
  \code{\link{read.landsat}},
  \code{\link{satellite-class}},
  \code{\link{summary,amsr-method}},
  \code{\link{summary,landsat-method}},
  \code{\link{summary,satellite-method}}
}
\concept{
satellite
}

