% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oasis_preproc.R
\name{oasis_preproc}
\alias{oasis_preproc}
\title{OASIS Image Preprocessing}
\usage{
oasis_preproc(flair, t1, t2, pd = NULL, brain_mask = NULL, verbose = TRUE,
  cores = 1)
}
\arguments{
\item{flair}{FLAIR volume of class \code{\link{nifti}}}

\item{t1}{T1 volume of class \code{\link{nifti}}}

\item{t2}{T2 volume of class \code{\link{nifti}}}

\item{pd}{PD volume of class \code{\link{nifti}}}

\item{brain_mask}{binary mask volume of class \code{\link{nifti}}}

\item{verbose}{a logical value for printing diagnostic output}

\item{cores}{numeric indicating the number of cores to be used 
(no more than 4 is useful for this software implementation)}
}
\value{
Returns a list of objects of class \code{\link{nifti}},
namely the inhomogeneity corrected FLAIR, T1, T2, and PD registered to the
space of the T1 volume.
}
\description{
This function does the required preprocessing for OASIS for the FLAIR, T2,
T1, and PD volumes using FSL through \code{fslr}.
The preprocessing steps are
(1) inhomogeneity correct using \code{\link{fsl_biascorrect}}
and (2) rigid registration using \code{\link{flirt}} to the T1 space.
}
\examples{
library(neurobase)
dl_file = function(url) {
   tfile = tempfile(fileext = ".nii.gz")
   req <- httr::GET(url,
   httr::write_disk(path = tfile))
   httr::stop_for_status(req)
   tfile
}
in_ci <- function() {
 nzchar(Sys.getenv("CI"))
}
on_cran = function() {
 identical(Sys.getenv("NOT_CRAN"), "false")
} 
if (in_ci() || on_cran()) {
  if (fslr::have.fsl() && require(httr)) {
    mods = c("FLAIR", "T1W", "T2W", "consensus_gt", "brainmask")
    base_url = file.path(
      "https://raw.githubusercontent.com/muschellij2/open_ms_data", 
      "master/cross_sectional/coregistered/patient01/")
    files = paste0(base_url, mods, ".nii.gz")
    files = sapply(files, dl_file)
    names(files) = mods

    flair <- readnii(files["FLAIR"])
    t1 <- readnii(files["T1W"])
    t2 <- readnii(files["T2W"])
    brain_mask <- readnii(files["brainmask"])
    gold_standard = readnii(files["consensus_gt"])
    oasis_preprocessed_data <- oasis_preproc(flair, t1, t2, 
      brain_mask = brain_mask)
  } 
}
}
