% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getMedia.R
\name{getMedia}
\alias{getMedia}
\title{Gets a given media track for a given graph.}
\usage{
getMedia(labbcat.url, id, trackSuffix = "", mimeType = "audio/wav")
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{A graph ID (i.e. transcript name)}

\item{trackSuffix}{The track suffix of the media}

\item{mimeType}{The MIME type of the media}
}
\value{
A URL to the given media for the given graph
}
\description{
Gets a given media track for a given graph.
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get URL for the WAV file for BR2044_OllyOhlson.eaf
media <- getMedia(labbcat.url, "BR2044_OllyOhlson.eaf")

## Get URL for the 'QuakeFace' video file for BR2044_OllyOhlson.eaf
media <- getMedia(labbcat.url, "BR2044_OllyOhlson.eaf", "_face", "video/mp4")
}

}
\seealso{
\link{getGraphIds}
}
\keyword{audio}
\keyword{media}
