% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getFragments.R
\name{getFragments}
\alias{getFragments}
\title{Gets fragments of annotation graphs (transcripts) from 'LaBB-CAT', 
converted to a given format (by default, Praat TextGrid)}
\usage{
getFragments(
  labbcat.url,
  id,
  start,
  end,
  layerId,
  mimeType = "text/praat-textgrid",
  no.progress = FALSE,
  path = ""
)
}
\arguments{
\item{labbcat.url}{URL to the LaBB-CAT instance}

\item{id}{The graph ID (transcript name) of the sound recording, or
a vector of graph IDs.}

\item{start}{The start time in seconds, or a vector of start times.}

\item{end}{The end time in seconds, or a vector of end times.}

\item{layerId}{A vector of layer IDs.}

\item{mimeType}{Optional content-type - currently only "text/praat-textgrid"
is supported.}

\item{no.progress}{Optionally suppress the progress bar when
multiple fragments are  specified - TRUE for no progress bar.}

\item{path}{Optional path to directory where tge files should be saved.}
}
\value{
The name of the file, which is saved in the current
    directory, or a list of names of files, if multiple
    id's/start's/end's were specified 

If a list of files is returned, they are in the order that they
    were returned by the server, which *should* be the order that
    they were specified in the id/start/end lists.
}
\description{
Gets fragments of annotation graphs (transcripts) from 'LaBB-CAT', 
converted to a given format (by default, Praat TextGrid)
}
\examples{
\dontrun{
## define the LaBB-CAT URL
labbcat.url <- "https://labbcat.canterbury.ac.nz/demo/"

## Get the 5 seconds starting from 10s after the beginning of a recording
textgrid.file <- getFragments(labbcat.url, "AP2505_Nelson.eaf", 10.0, 15.0,
    c("transcript", "phonemes"), path="samples") 

## Load some search results previously exported from LaBB-CAT
results <- read.csv("results.csv", header=T)

## Get a list of fragment TextGrids, including the utterances, transcript, and phonemes layers
textgrid.files <- getFragments(
    labbcat.url, results$Transcript, results$Line, results$LineEnd,
    c("utterances", "transcript", "phonemes"))

## Get a list of fragment TextGrids with no progress bar
textgrid.files <- getFragments(
    labbcat.url, results$Transcript, results$Line, results$LineEnd, no.progress=TRUE)
}
}
\keyword{fragment}
\keyword{sample}
\keyword{sound}
\keyword{wav}
