% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dig_contrasts.R
\name{dig_contrasts}
\alias{dig_contrasts}
\title{Search for contrast patterns}
\usage{
dig_contrasts(
  x,
  condition = where(is.logical),
  xvars = where(is.numeric),
  yvars = where(is.numeric),
  method = "t",
  alternative = "two.sided",
  min_length = 0L,
  max_length = Inf,
  min_support = 0,
  threads = 1,
  ...
)
}
\arguments{
\item{x}{a matrix or data frame with data to search in.}

\item{condition}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use as condition predicates}

\item{xvars}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use for computation of contrasts}

\item{yvars}{a tidyselect expression (see
\href{https://tidyselect.r-lib.org/articles/syntax.html}{tidyselect syntax})
specifying the columns to use for computation of contrasts}

\item{method}{a character string indicating which contrast to compute.
One of \code{"t"}, \code{"wilcox"}, or \code{"var"}. \code{"t"} (resp. \code{"wilcos"}) compute
a parametric (resp. non-parametric) test on equality in position, and
\code{"var"} performs the F-test on equality of variance.}

\item{alternative}{indicates the alternative hypothesis and must be one of
\code{"two.sided"}, \code{"greater"} or \code{"less"}. \code{"greater"} corresponds to
positive association, \code{"less"} to negative association.}

\item{min_length}{the minimum size (the minimum number of predicates) of the
condition to be generated (must be greater or equal to 0). If 0, the empty
condition is generated in the first place.}

\item{max_length}{The maximum size (the maximum number of predicates) of the
condition to be generated. If equal to Inf, the maximum length of conditions
is limited only by the number of available predicates.}

\item{min_support}{the minimum support of a condition to trigger the callback
function for it. The support of the condition is the relative frequency
of the condition in the dataset \code{x}. For logical data, it equals to the
relative frequency of rows such that all condition predicates are TRUE on it.
For numerical (double) input, the support is computed as the mean (over all
rows) of multiplications of predicate values.}

\item{threads}{the number of threads to use for parallel computation.}

\item{...}{Further arguments passed to the underlying test function
(\code{\link[=t.test]{t.test()}}, \code{\link[=wilcox.test]{wilcox.test()}}, or \code{\link[=var.test]{var.test()}} accordingly to the
selected method).}
}
\value{
A tibble with found rules.
}
\description{
Search for contrast patterns
}
\seealso{
\code{\link[=dig]{dig()}}, \code{\link[=dig_grid]{dig_grid()}}, \code{\link[stats:t.test]{stats::t.test()}}, \code{\link[stats:wilcox.test]{stats::wilcox.test()}}, \code{\link[stats:var.test]{stats::var.test()}}
}
\author{
Michal Burda
}
