% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spots_combined.R
\name{spots.combined.file}
\alias{spots.combined.file}
\title{Find spots using information from two channels}
\usage{
spots.combined.file(file, size = NULL, voxelsize = NULL, folder = "./",
  thresh.offset = 0.1, min.sum.intensity = 2, max.distance = 0.5,
  use.brightest = FALSE, max.spots = 2, full.voxel = FALSE,
  output = "markers")
}
\arguments{
\item{file}{File name}

\item{size}{size of img in microns, if size and voxelsize are NULL, size is determined from folder XYZmic}

\item{voxelsize}{size of voxel in microns}

\item{folder}{Folder}

\item{thresh.offset}{Thresh offest used in EBImage::thresh()}

\item{min.sum.intensity}{spots smaller than min.sum.intensity are ignored}

\item{max.distance}{use only spots with distance to other color spot smaller than max.distance}

\item{use.brightest}{Logical; use only brightest in max.distance?}

\item{max.spots}{maximum of spots (per channel), only when use brightest=TRUE}

\item{full.voxel}{Logical; output contains full voxel instead of rgb intensities}

\item{output}{output folder}
}
\value{
RGB image with spots will be written to output folder
}
\description{
Find spots using information from two channels
}

