% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likelihood.R
\name{grad_likelihood_fn}
\alias{grad_likelihood_fn}
\title{Gradient of the GrOU likelihood function with penalty.}
\usage{
grad_likelihood_fn(
  times,
  data,
  thresholds,
  div = 1e+05,
  use_scaling = FALSE,
  log = TRUE
)
}
\arguments{
\item{times}{Times at which data is given}

\item{data}{Values to compute the MLE with.}

\item{thresholds}{Jump threshold values.}

\item{div}{Batch size/divisor to avoid large memory allocation.}

\item{use_scaling}{Brownian motion covariance matrix scaling
in the likelihood.}

\item{log}{Log-scale for the likelihood or not (defaults to \code{FALSE}).}
}
\value{
(Log)likelihood of the GrOU process with penalty.
}
\description{
Gradient of the GrOU likelihood function with penalty.
}
\examples{
n <- 1000
d <- 10
times <- seq(n)
delta_time <- 0.01
beta_value <- 0.499
noise <- matrix(rnorm(n * d, sd = sqrt(delta_time)), ncol = d)
data <- construct_path(
  diag(d),
  noise = noise, y_init = rep(0, d), delta_time = delta_time
)
thresholds <- rep(delta_time^beta_value, d)
grad_loglik <- grad_likelihood_fn(
  times = times, data = data, thresholds = thresholds, div = 1e2
)
grad_loglik(diag(d))
}
