% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nse.R
\name{nse.hiruk}
\alias{nse.hiruk}
\title{Hirukawa estimator}
\usage{
nse.hiruk(x, type = c("bartlett", "parzen"), lag.prewhite = 0)
}
\arguments{
\item{x}{A numeric vector.}

\item{type}{The type of kernel used among \code{"bartlett"} and \code{"parzen"}. Default is \code{type = "Bartlett"}.}

\item{lag.prewhite}{Prewhite the series before analysis (integer or \code{NULL}). When \code{lag.prewhite = NULL} this performs automatic lag selection. Default is \code{lag.prewhite = 0} that is no prewhitening.}
}
\value{
The NSE estimator.
}
\description{
Function which calculates the numerical standard error with the kernel based variance estimator
by Andrews (1991) using Hirukawa (2010) automatic bandwidth estimator.
}
\note{
\code{nse.hiruk} is a wrapper around \code{\link[sandwich]{lrvar}} from
the \code{\link{sandwich}} package and uses Hirukawa (2010) bandwidth estimator.
See the documentation of \code{\link{sandwich}} for details.
}
\examples{
\dontrun{
n    = 1000
ar   = 0.9
mean = 1
sd   = 1

set.seed(1234)
x = c(arima.sim(n = n, list(ar = ar), sd = sd) + mean)
nse.hiruk(x = x, type = "parzen", lag.prewhite = 0)
nse.hiruk(x = x, type = "bartlett", lag.prewhite = NULL)
}
}
\references{
Hirukawa, M. (2010).
A two-stage plug-in bandwidth selection and its implementation for covariance estimation.
\emph{Econometric Theory} \bold{26}(3),  710-743.
}
\author{
David Ardia and Keven Bluteau
}
