C===================================================== REGTST.FOR
      SUBROUTINE REGTST(NSITES,NAMES,LEN,XMOM,A,B,SEED,NSIM,NPROB,PROB,
     * KPRINT,KOUT,RMOM,D,VOBS,VBAR,VSD,H,Z,PARA,RPARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C* VERSION 3.03 JUNE 2000 *
C* * CHARACTER variable declarations changed to conform with *
C* Fortran-77 standard *
C* *
C***********************************************************************
C
C CALCULATES THREE STATISTICS USEFUL IN REGIONAL FREQUENCY ANALYSIS
C
C DISCORDANCY MEASURE, D(I), FOR INDIVIDUAL SITES IN A REGION.
C LARGE VALUES MIGHT BE USED AS A FLAG TO INDICATE POTENTIAL ERRORS
C IN THE DATA AT THE SITE. "LARGE" MIGHT BE 3 FOR REGIONS WITH 15
C OR MORE SITES, BUT LESS (EXACT VALUES IN ARRAY DC1) FOR SMALLER
C REGIONS.
C
C HETEROGENEITY MEASURES, H(J), FOR A REGION BASED UPON EITHER:-
C J=1: THE WEIGHTED S.D. OF THE L-CVS OR
C J=2: THE AVERAGE DISTANCE FROM THE SITE TO THE REGIONAL AVERAGE
C ON A GRAPH OF L-CV VS. L-SKEWNESS
C J=3: THE AVERAGE DISTANCE FROM THE SITE TO THE REGIONAL AVERAGE
C ON A GRAPH OF L-SKEWNESS VS. L-KURTOSIS
C
C IN PRACTICE H(1) IS PROBABLY SUFFICIENT. A VALUE GREATER THAN
C (SAY) 1.0 SUGGESTS THAT FURTHER SUBDIVISION OF THE REGION SHOULD
C BE CONSIDERED AS IT MIGHT IMPROVE QUANTILE ESTIMATES.
C
C GOODNESS-OF-FIT MEASURES, Z(K), FOR 5 CANDIDATE DISTRIBUTIONS:
C K=1: GENERALIZED LOGISTIC
C K=2: GENERALIZED EXTREME VALUE
C K=3: GENERALIZED NORMAL (LOGNORMAL)
C K=4: PEARSON TYPE III (3-PARAMETER GAMMA)
C K=5: GENERALIZED PARETO
C
C PROVIDED THAT THE REGION IS ACCEPTABLY CLOSE TO HOMOGENEOUS,
C THE FIT MAY BE JUDGED ACCEPTABLE AT 10% SIGNIFICANCE LEVEL
C IF Z(K) IS LESS THAN 1.645 IN ABSOLUTE VALUE.
C
C FOR FURTHER DETAILS SEE J.R.M. HOSKING AND J.R. WALLIS (1997),
C "REGIONAL FREQUENCY ANALYSIS: AN APPROACH BASED ON L-MOMENTS",
C CAMBRIDGE UNIVERSITY PRESS, CHAPTERS 3-5.
C
C PARAMETERS OF ROUTINE:
C NSITES * INPUT* NUMBER OF SITES IN REGION
C NAMES * INPUT* CHARACTER*12 ARRAY OF LENGTH NSITES. SITE NAMES.
C LEN * INPUT* ARRAY OF LENGTH NSITES. RECORD LENGTHS AT EACH SITE.
C XMOM * INPUT* ARRAY OF DIMENSION (5,NSITES). ARRAY CONTAINING
C THE FIRST 5 SAMPLE L-MOMENTS FOR EACH SITE, IN THE
C ORDER MEAN, L-CV, L-SKEWNESS, L-KURTOSIS, T-5, I.E
C XMOM(I,J) CONTAINS THE I'TH L-MOMENT FOR SITE J.
C N.B. XMOM(2,.) CONTAINS L-CV, NOT THE USUAL L-2!
C A * INPUT* ) PARAMETERS OF
C B * INPUT* ) PLOTTING POSITION.
C NOTE: A AND B SHOULD BE THE SAME AS THE VALUES USED
C TO CALCULATE THE MOMENTS IN THE XMOM ARRAY.
C SEED * INPUT* SEED FOR RANDOM NUMBER GENERATOR. SHOULD BE A WHOLE
C NUMBER IN THE RANGE 2D0 TO 2147483647D0.
C NSIM * INPUT* NUMBER OF SIMULATED WORLDS FOR HETEROGENEITY AND
C GOODNESS-OF-FIT TESTS.
C NOTE: NSIM=0 WILL FORCE RETURN AT COMPLETION OF
C OUTLIER TEST. NSIM=1 WILL SUPPRESS CALCULATION OF
C H AND Z STATISTICS, BUT PARAMETER AND QUANTILE
C ESTIMATES WILL BE FOUND.
C NPROB * INPUT* NUMBER OF QUANTILES TO BE CALCULATED
C PROB * INPUT* ARRAY OF LENGTH NPROB. PROBABILITIES FOR WHICH
C QUANTILES ARE TO BE CALCULATED.
C KPRINT * INPUT* OUTPUT FLAG. SHOULD BE SET TO
C 0 TO SUPPRESS OUTPUT
C 1 TO PRINT OUTPUT
C KOUT * INPUT* CHANNEL TO WHICH OUTPUT IS DIRECTED
C RMOM *OUTPUT* ARRAY OF LENGTH 5. ON EXIT, CONTAINS THE REGIONAL
C WEIGHTED AVERAGE L-MOMENT RATIOS.
C D *OUTPUT* ARRAY OF LENGTH NSITES. ON EXIT, CONTAINS THE
C DISCORDANCY MEASURE (D STATISTIC) FOR EACH SITE.
C VOBS *OUTPUT* ARRAY OF LENGTH 3. ON EXIT, CONTAINS THE REGIONAL
C OBSERVED VALUES OF 3 HETEROGENEITY STATISTICS:
C (1) WEIGHTED S.D. OF L-CVS;
C (2) AVERAGE OF L-CV/L-SKEW DISTANCES;
C (3) AVERAGE OF L-SKEW/L-KURTOSIS DISTANCES.
C VBAR *OUTPUT* ARRAY OF LENGTH 3. ON EXIT, CONTAINS THE MEAN OF THE
C SIMULATED VALUES OF THE 3 HETEROGENEITY STATISTICS.
C VSD *OUTPUT* ARRAY OF LENGTH 3. ON EXIT, CONTAINS THE S.D. OF THE
C SIMULATED VALUES OF THE 3 HETEROGENEITY STATISTICS.
C H *OUTPUT* ARRAY OF LENGTH 3. ON EXIT, CONTAINS HETEROGENEITY
C MEASURES (H STATISTICS), I.E. H=(VOBS-VBAR)/VSD.
C Z *OUTPUT* ARRAY OF LENGTH 5. ON EXIT, CONTAINS GOODNESS-OF-FIT
C MEASURES (Z STATISTICS) FOR 5 DISTRIBUTIONS:
C (1) GEN. LOGISTIC, (2) GEN. EXTREME VALUE,
C (3) GEN. NORMAL, (4) PEARSON TYPE III,
C (5) GEN. PARETO.
C PARA *OUTPUT* ARRAY OF DIMENSION (5,6). ON EXIT, IF NSIM.GE.1,
C CONTAINS PARAMETERS OF GROWTH CURVES FITTED BY THE
C ABOVE 5 DISTRIBUTIONS, PLUS WAKEBY.
C
C OTHER ROUTINES USED: DERF,DIGAMD,DLGAMA,DURAND,GAMIND,PELGEV,PELGLO,
C PELGNO,PELGPA,PELKAP,PELPE3,PELWAK,QUAGAM,QUAGEV,QUAGLO,QUAGNO,
C QUAGPA,QUAKAP,QUAPE3,QUASTN,QUAWAK,SAMLMR,SORT
C
C QUANTITIES DEFINED IN PARAMETER STATEMENT:
C MAXNS - MUST BE AT LEAST AS LARGE AS NSITES
C MAXREC - MUST BE AT LEAST AS LARGE AS EACH ELEMENT OF ARRAY LEN
C MAXQ - MUST BE AT LEAST AS LARGE AS NPROB
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXNS=200,MAXQ=30,MAXREC=200)
C
      CHARACTER*1 BLANK,STAR,LOOK1,LOOK2
      CHARACTER*12 NAMES(NSITES)
      CHARACTER*18 DISTRI(6)
      DOUBLE PRECISION D(NSITES),DC1(14),DC2(18),H(3),PARA(5,6),
     * PROB(NPROB),Q(MAXQ),RMOM(5),RPARA(4),SMAT(3,3),TMOM(4),T4FIT(5),
     * VBAR(3),VOBS(3),VSD(3),WORK(MAXNS,3),X(MAXREC),XMOM(5,NSITES),
     * Z(5)
      INTEGER LEN(NSITES)
      DATA BLANK/' '/,STAR/'*'/
      DATA ZERO/0D0/,ONE/1D0/,TWO/2D0/,THREE/3D0/
      DATA DISTRI/
     * 'GEN. LOGISTIC ','GEN. EXTREME VALUE','GEN. NORMAL ',
     * 'PEARSON TYPE III ','GEN. PARETO ','WAKEBY '/
C
C COEFFICIENTS OF POWER-SERIES APPROXIMATIONS OF TAU-4 IN TERMS
C OF TAU-3, FOR THE FIRST 5 DISTRIBUTIONS IN ARRAY DISTRI
C
      DATA GLOC0,GLOC2/0.16667D0,0.83333D0/
      DATA GEVC0,GEVC1,GEVC2,GEVC3,GEVC4,GEVC5,GEVC6/
     * 0.10701D0, 0.11090D0, 0.84838D0,-0.06669D0,
     * 0.00567D0,-0.04208D0, 0.03763D0/
      DATA GNOC0,GNOC2,GNOC4,GNOC6,GNOC8/
     * 0.12282D0,0.77518D0,0.12279D0,-0.13638D0,0.11368D0/
      DATA PE3C0,PE3C2,PE3C4,PE3C6,PE3C8/
     * 0.12240D0,0.30115D0,0.95812D0,-0.57488D0,0.19383D0/
      DATA GPAC1,GPAC2,GPAC3,GPAC4/
     * 0.20196D0,0.95924D0,-0.20096D0,0.04061D0/
C
C CRITICAL VALUES FOR D, H AND Z STATISTICS
C
      DATA DC1/4*3D0,1.3330D0,1.6481D0,1.9166D0,2.1401D0,2.3287D0,
     * 2.4906D0,2.6321D0,2.7573D0,2.8694D0,2.9709D0/
      DATA DC2/4*4D0,1.3333D0,1.6648D0,1.9821D0,2.2728D0,2.5337D0,
     * 2.7666D0,2.9748D0,3.1620D0,3.3310D0,3.4844D0,
     * 3.6246D0,3.7532D0,3.8718D0,3.9816D0/
      DATA HCRIT1,HCRIT2/1D0,2D0/
      DATA ZCRIT/1.645D0/
C
C INITIALIZE ARRAYS
C
      NMAX=0
      SUMLEN=0
      DO 10 I=1,NSITES
      NREC=LEN(I)
      IF(NREC.GT.NMAX)NMAX=NREC
      SUMLEN=SUMLEN+NREC
   10 D(I)=ZERO
      DO 20 K=1,3
      VOBS(K)=ZERO
      VBAR(K)=ZERO
      VSD(K)=ZERO
      H(K)=ZERO
   20 CONTINUE
      DO 30 IDIST=1,5
   30 Z(IDIST)=ZERO
      DO 40 IPARA=1,5
      DO 40 IDIST=1,6
   40 PARA(IPARA,IDIST)=ZERO
      IF(NSITES.GT.MAXNS)GOTO 1000
C
C CALCULATE THE WEIGHTED MEAN OF L-CV, L-SKEW, L-KURTOSIS
C
      DO 60 K=2,5
      RMOM(K)=ZERO
      DO 50 I=1,NSITES
   50 RMOM(K)=RMOM(K)+LEN(I)*XMOM(K,I)
   60 RMOM(K)=RMOM(K)/SUMLEN
      RMOM(1)=ONE
C
C CALCULATE SUM OF SQUARES MATRIX
C
      IF(NSITES.LE.3)GOTO 135
      SUM2=ZERO
      SUM3=ZERO
      SUM4=ZERO
      DO 70 I=1,NSITES
      SUM2=SUM2+XMOM(2,I)
      SUM3=SUM3+XMOM(3,I)
      SUM4=SUM4+XMOM(4,I)
   70 CONTINUE
      SUM2=SUM2/NSITES
      SUM3=SUM3/NSITES
      SUM4=SUM4/NSITES
      DO 80 I=1,NSITES
      WORK(I,1)=XMOM(2,I)-SUM2
      WORK(I,2)=XMOM(3,I)-SUM3
      WORK(I,3)=XMOM(4,I)-SUM4
   80 CONTINUE
      DO 100 J=1,3
      DO 100 K=J,3
      SMAT(J,K)=ZERO
      DO 90 I=1,NSITES
   90 SMAT(J,K)=SMAT(J,K)+WORK(I,J)*WORK(I,K)
  100 CONTINUE
C
C INVERT SUM OF SQUARES MATRIX
C
      DO 110 K=1,3
      IF(SMAT(1,1).LE.ZERO)GOTO 1030
      TEMP0=ONE/SMAT(1,1)
      TEMP1=-SMAT(1,2)*TEMP0
      TEMP2=-SMAT(1,3)*TEMP0
      IF(K.GT.2)TEMP1=-TEMP1
      IF(K.GT.1)TEMP2=-TEMP2
      SMAT(1,1)=SMAT(2,2)+TEMP1*SMAT(1,2)
      SMAT(1,2)=SMAT(2,3)+TEMP1*SMAT(1,3)
      SMAT(2,2)=SMAT(3,3)+TEMP2*SMAT(1,3)
      SMAT(1,3)=TEMP1
      SMAT(2,3)=TEMP2
      SMAT(3,3)=TEMP0
  110 CONTINUE
      SMAT(2,1)=SMAT(1,2)
      SMAT(3,1)=SMAT(1,3)
      SMAT(3,2)=SMAT(2,3)
C
C CALCULATE DISCORDANCY MEASURES (D STATISTICS)
C
      FACTOR=NSITES/THREE
      DO 130 I=1,NSITES
      DO 120 J=1,3
      DO 120 K=1,3
  120 D(I)=D(I)+WORK(I,J)*WORK(I,K)*SMAT(J,K)
      D(I)=D(I)*FACTOR
      WORK(I,1)=D(I)
  130 CONTINUE
      CALL SORT(WORK(1,1),NSITES)
      GOTO 140
  135 DO 138 I=1,NSITES
  138 D(I)=ONE
C
C PRINT DISCORDANCY MEASURES
C
  140 CONTINUE
      IF(KPRINT.LE.0)GOTO 160
      WRITE(KOUT,6000)
      DCRIT1=DC1(1)
      DCRIT2=DC2(1)
      IF(NSITES.LE.14)DCRIT1=DC1(NSITES)
      IF(NSITES.LE.18)DCRIT2=DC2(NSITES)
      KSTART=1
      DO 150 I=1,NSITES
      LOOK1=BLANK
      LOOK2=BLANK
      IF(D(I).GE.DCRIT1)LOOK1=STAR
      IF(D(I).GE.DCRIT2)LOOK2=STAR
      IF(D(I).LT.DCRIT1)KSTART=KSTART+1
      WRITE(KOUT,6010)I,LEN(I),NAMES(I),(XMOM(K,I),K=2,4),
     * D(I),LOOK1,LOOK2
  150 CONTINUE
      WRITE(KOUT,6020)(RMOM(K),K=2,4)
      IF(KSTART.LT.NSITES)WRITE(KOUT,6030)(WORK(K,1),K=KSTART,NSITES)
  160 CONTINUE
C
      IF(NSIM.LE.0)RETURN
      IF(NPROB.GT.MAXQ)GOTO 1010
      IF(NSIM.EQ.1)GOTO 270
      IF(NMAX.GT.MAXREC)GOTO 1020
C
C FIT KAPPA DISTRIBUTION TO REGIONAL L-MOMENTS
C
      CALL PELKAP(RMOM,RPARA,IFAIL)
      IF(IFAIL.EQ.0)GOTO 180
      CALL PELGLO(RMOM,RPARA)
      RPARA(4)=-ONE
  180 IF(KPRINT.GT.0)WRITE(KOUT,6040)(RPARA(K),K=1,4)
C
C START THE NSIM REPETITIONS
C
      T4BAR=ZERO
      T4SD=ZERO
      DO 220 ISIM=1,NSIM
      SUM2=ZERO
      SUM3=ZERO
      SUM4=ZERO
C
C START OF LOOP OVER SITES
C
      DO 200 I=1,NSITES
      NREC=LEN(I)
C
C GET VECTOR OF UNIFORM RANDOM NUMBERS
C
      CALL DURAND(SEED,NREC,X)
C
C TRANSFORM FROM UNIFORM TO KAPPA
C
      DO 190 J=1,NREC
      X(J)=QUAKAP(X(J),RPARA)
  190 CONTINUE
C
C FIND L-MOMENTS OF SIMULATED DATA
C
      CALL SORT(X,NREC)
      CALL SAMLMR(X,NREC,TMOM,4,A,B)
      CV=TMOM(2)/TMOM(1)
      WORK(I,1)=CV
      WORK(I,2)=TMOM(3)
      WORK(I,3)=TMOM(4)
      SUM2=SUM2+NREC*CV
      SUM3=SUM3+NREC*TMOM(3)
      SUM4=SUM4+NREC*TMOM(4)
C
C END OF LOOP OVER SITES
C
  200 CONTINUE
C
      SUM2=SUM2/SUMLEN
      SUM3=SUM3/SUMLEN
      SUM4=SUM4/SUMLEN
      T4BAR=T4BAR+SUM4
      T4SD=T4SD+SUM4**2
C
C CALCULATE HETEROGENEITY V-STATISTICS FOR SIMULATED DATA
C
      IF(NSITES.EQ.1)GOTO 215
      V1=ZERO
      V2=ZERO
      V3=ZERO
      DO 210 I=1,NSITES
      NREC=LEN(I)
      TEMP2=(WORK(I,1)-SUM2)**2
      TEMP3=(WORK(I,2)-SUM3)**2
      TEMP4=(WORK(I,3)-SUM4)**2
      V1=V1+NREC*TEMP2
      V2=V2+NREC*DSQRT(TEMP2+TEMP3)
      V3=V3+NREC*DSQRT(TEMP3+TEMP4)
  210 CONTINUE
      V1=DSQRT(V1/SUMLEN)
      V2=V2/SUMLEN
      V3=V3/SUMLEN
      VBAR(1)=VBAR(1)+V1
      VBAR(2)=VBAR(2)+V2
      VBAR(3)=VBAR(3)+V3
      VSD(1)=VSD(1)+V1**2
      VSD(2)=VSD(2)+V2**2
      VSD(3)=VSD(3)+V3**2
  215 CONTINUE
C
C END OF THE NSIM REPETITIONS
C
  220 CONTINUE
C
C CALCULATE HETEROGENEITY V-STATISTICS FOR OBSERVED DATA
C
      IF(NSITES.EQ.1)GOTO 235
      V1=ZERO
      V2=ZERO
      V3=ZERO
      DO 225 I=1,NSITES
      NREC=LEN(I)
      TEMP2=(XMOM(2,I)-RMOM(2))**2
      TEMP3=(XMOM(3,I)-RMOM(3))**2
      TEMP4=(XMOM(4,I)-RMOM(4))**2
      V1=V1+NREC*TEMP2
      V2=V2+NREC*DSQRT(TEMP2+TEMP3)
      V3=V3+NREC*DSQRT(TEMP3+TEMP4)
  225 CONTINUE
      VOBS(1)=DSQRT(V1/SUMLEN)
      VOBS(2)=V2/SUMLEN
      VOBS(3)=V3/SUMLEN
C
C CALCULATE AND PRINT HETEROGENEITY MEASURES (H STATISTICS)
C
      IF(KPRINT.GT.0)WRITE(KOUT,6050)NSIM
      DO 230 J=1,3
      VBAR(J)=VBAR(J)/NSIM
      VSD(J)=DSQRT((VSD(J)-NSIM*VBAR(J)**2)/(NSIM-ONE))
      H(J)=(VOBS(J)-VBAR(J))/VSD(J)
      IF(KPRINT.LE.0)GOTO 230
      LOOK1=BLANK
      LOOK2=BLANK
      IF(H(J).GE.HCRIT1)LOOK1=STAR
      IF(H(J).GE.HCRIT2)LOOK2=STAR
      IF(J.EQ.1)WRITE(KOUT,6060)VOBS(J),VBAR(J),VSD(J),H(J),LOOK1,LOOK2
      IF(J.EQ.2)WRITE(KOUT,6070)VOBS(J),VBAR(J),VSD(J),H(J),LOOK1,LOOK2
      IF(J.EQ.3)WRITE(KOUT,6080)VOBS(J),VBAR(J),VSD(J),H(J),LOOK1,LOOK2
  230 CONTINUE
  235 CONTINUE
C
C FIND TAU-4 VALUES OF EACH CANDIDATE DISTRIBUTION
C
      S=RMOM(3)
      SS=S*S
      T4FIT(1)=GLOC0+SS*GLOC2
      T4FIT(2)=
     * GEVC0+S*(GEVC1+S*(GEVC2+S*(GEVC3+S*(GEVC4+S*(GEVC5+S*GEVC6)))))
      T4FIT(3)=GNOC0+SS*(GNOC2+SS*(GNOC4+SS*(GNOC6+SS*GNOC8)))
      T4FIT(4)=PE3C0+SS*(PE3C2+SS*(PE3C4+SS*(PE3C6+SS*PE3C8)))
      T4FIT(5)=S*(GPAC1+S*(GPAC2+S*(GPAC3+S*GPAC4)))
C
C CALCULATE GOODNESS-OF-FIT MEASURES (Z STATISTICS)
C
      T4BAR=T4BAR/NSIM
      T4SD=DSQRT((T4SD-NSIM*T4BAR**2)/(NSIM-ONE))
      DO 240 IDIST=1,5
      Z(IDIST)=(T4FIT(IDIST)+T4BAR-TWO*RMOM(4))/T4SD
  240 CONTINUE
C
C PRINT Z STATISTICS
C
      IF(KPRINT.LE.0)GOTO 260
      WRITE(KOUT,6090)NSIM
      DO 250 IDIST=1,5
      LOOK1=BLANK
      IF(DABS(Z(IDIST)).LT.ZCRIT)LOOK1=STAR
  250 WRITE(KOUT,6100)DISTRI(IDIST),T4FIT(IDIST),Z(IDIST),LOOK1
  260 CONTINUE
C
C FIT DISTRIBUTIONS
C
  270 CONTINUE
      CALL PELGLO(RMOM,PARA(1,1))
      CALL PELGEV(RMOM,PARA(1,2))
      CALL PELGNO(RMOM,PARA(1,3))
      CALL PELPE3(RMOM,PARA(1,4))
      CALL PELGPA(RMOM,PARA(1,5))
      CALL PELWAK(RMOM,PARA(1,6),IFAIL)
C
C FOR SUCCESSFUL CANDIDATES AND WAKEBY, PRINT PARAMETERS ...
C
      IF(KPRINT.LE.0)GOTO 320
      IF(NSIM.EQ.1)WRITE(KOUT,6110)
      IF(NSIM.GT.1)WRITE(KOUT,6120)
      DO 280 IDIST=1,5
      IF(DABS(Z(IDIST)).LE.ZCRIT)
     * WRITE(KOUT,6130)DISTRI(IDIST),(PARA(IPARA,IDIST),IPARA=1,3)
  280 CONTINUE
      WRITE(KOUT,6130)DISTRI(6),(PARA(IPARA,6),IPARA=1,5)
C
C ... AND ESTIMATE AND PRINT QUANTILES
C
      IF(NPROB.EQ.0)GOTO 320
      WRITE(KOUT,6140)PROB
      DO 300 IDIST=1,5
      IF(DABS(Z(IDIST)).GT.ZCRIT)GOTO 300
      DO 290 IQ=1,NPROB
      IF(IDIST.EQ.1)Q(IQ)=QUAGLO(PROB(IQ),PARA(1,1))
      IF(IDIST.EQ.2)Q(IQ)=QUAGEV(PROB(IQ),PARA(1,2))
      IF(IDIST.EQ.3)Q(IQ)=QUAGNO(PROB(IQ),PARA(1,3))
      IF(IDIST.EQ.4)Q(IQ)=QUAPE3(PROB(IQ),PARA(1,4))
      IF(IDIST.EQ.5)Q(IQ)=QUAGPA(PROB(IQ),PARA(1,5))
  290 CONTINUE
      WRITE(KOUT,6150)DISTRI(IDIST),(Q(IQ),IQ=1,NPROB)
  300 CONTINUE
      DO 310 IQ=1,NPROB
  310 Q(IQ)=QUAWAK(PROB(IQ),PARA(1,6))
      WRITE(KOUT,6150)DISTRI(6),(Q(IQ),IQ=1,NPROB)
  320 CONTINUE
C
      RETURN
C
 1000 WRITE(KOUT,7000)'MAXNS'
      RETURN
 1010 WRITE(KOUT,7000)'MAXQ'
      RETURN
 1020 WRITE(KOUT,7000)'MAXREC'
      RETURN
 1030 WRITE(KOUT,7010)
      GOTO 140
C
 6000 FORMAT(/' SITE N NAME L-CV L-SKEW L-KURT D(I)')
 6010 FORMAT(2I5,2X,A12,3F8.4,F7.2,2X,2A1)
 6020 FORMAT(/5X,'WEIGHTED MEANS',5X,6F8.4)
 6030 FORMAT(/' FLAGGED TEST VALUES'/(15F5.1))
 6040 FORMAT(/' PARAMETERS OF REGIONAL KAPPA DISTRIBUTION ',4F8.4)
 6050 FORMAT(//' ***** HETEROGENEITY MEASURES *****'/
     * ' (NUMBER OF SIMULATIONS =',I6,')')
 6060 FORMAT(/' OBSERVED S.D. OF GROUP L-CV =',F8.4/
     * ' SIM. MEAN OF S.D. OF GROUP L-CV =',F8.4/
     * ' SIM. S.D. OF S.D. OF GROUP L-CV =',F8.4/
     * ' STANDARDIZED TEST VALUE H(1) =',F6.2,2X,2A1)
 6070 FORMAT(/' OBSERVED AVE. OF L-CV / L-SKEW DISTANCE =',F8.4/
     * ' SIM. MEAN OF AVE. L-CV / L-SKEW DISTANCE =',F8.4/
     * ' SIM. S.D. OF AVE. L-CV / L-SKEW DISTANCE =',F8.4/
     * ' STANDARDIZED TEST VALUE H(2) =',F6.2,2X,2A1)
 6080 FORMAT(/' OBSERVED AVE. OF L-SKEW/L-KURT DISTANCE =',F8.4/
     * ' SIM. MEAN OF AVE. L-SKEW/L-KURT DISTANCE =',F8.4/
     * ' SIM. S.D. OF AVE. L-SKEW/L-KURT DISTANCE =',F8.4/
     * ' STANDARDIZED TEST VALUE H(3) =',F6.2,2X,2A1)
 6090 FORMAT(//' ***** GOODNESS-OF-FIT MEASURES *****'/
     * ' (NUMBER OF SIMULATIONS =',I6,')'/)
 6100 FORMAT(1X,A18,2X,' L-KURTOSIS=',F6.3,2X,' Z VALUE=',F6.2,1X,A1)
 6110 FORMAT(//' PARAMETER ESTIMATES'/)
 6120 FORMAT(//' PARAMETER ESTIMATES FOR DISTRIBUTIONS ACCEPTED AT THE',
     * ' 90% LEVEL'/)
 6130 FORMAT(1X,A18,1X,5F7.3)
 6140 FORMAT(/' QUANTILE ESTIMATES'/19X,(1X,14F7.3))
 6150 FORMAT(1X,A18,(1X,14F7.3))
C
 7000 FORMAT(' *** ERROR *** ROUTINE REGTST :',
     * ' INSUFFICIENT WORKSPACE - RECOMPILE WITH LARGER VALUE OF ',A6)
 7010 FORMAT(' *** ERROR *** ROUTINE REGTST : UNABLE TO INVERT',
     * ' SUM-OF-SQUARES MATRIX.'/31X,'D STATISTICS NOT CALCULATED.')
C
      END
C===================================================== PELEXP.FOR
      SUBROUTINE PELEXP(XMOM,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C PARAMETER ESTIMATION VIA L-MOMENTS FOR THE EXPONENTIAL DISTRIBUTION
C
C PARAMETERS OF ROUTINE:
C XMOM * INPUT* ARRAY OF LENGTH 2. CONTAINS THE L-MOMENTS LAMBDA-1,
C LAMBDA-2.
C PARA *OUTPUT* ARRAY OF LENGTH 2. ON EXIT, CONTAINS THE PARAMETERS
C IN THE ORDER XI, ALPHA (LOCATION, SCALE).
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(2),PARA(2)
      DATA ZERO/0D0/,TWO/2D0/
C
      IF(XMOM(2).LE.ZERO)GOTO 1000
      PARA(2)=TWO*XMOM(2)
      PARA(1)=XMOM(1)-PARA(2)
      RETURN
C
 1000 WRITE(6,7000)
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE PELEXP : L-MOMENTS INVALID')
      END
C===================================================== PELGAM.FOR
      SUBROUTINE PELGAM(XMOM,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C PARAMETER ESTIMATION VIA L-MOMENTS FOR THE GAMMA DISTRIBUTION
C
C PARAMETERS OF ROUTINE:
C XMOM * INPUT* ARRAY OF LENGTH 2. CONTAINS THE L-MOMENTS LAMBDA-1,
C LAMBDA-2.
C PARA *OUTPUT* ARRAY OF LENGTH 2. ON EXIT, CONTAINS THE PARAMETERS
C IN THE ORDER ALPHA, BETA (SHAPE, SCALE).
C
C OTHER ROUTINES USED: DLGAMA
C
C METHOD: RATIONAL APPROXIMATION IS USED TO EXPRESS ALPHA AS A FUNCTION
C OF L-CV. RELATIVE ACCURACY OF THE APPROXIMATION IS BETTER THAN 5E-5.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(2),PARA(2)
      DATA ZERO/0D0/,HALF/0.5D0/ONE/1D0/
C
C CONSTANTS USED IN MINIMAX APPROXIMATIONS
C
      DATA A1,A2,A3/-0.3080D0,-0.05812D0,0.01765D0/
      DATA B1,B2,B3,B4/0.7213D0,-0.5947D0,-2.1817D0,1.2113D0/
      DATA PI/3.1415927D0/
C
      IF(XMOM(1).LE.XMOM(2).OR.XMOM(2).LE.ZERO)GOTO 1000
      CV=XMOM(2)/XMOM(1)
      IF(CV.GE.HALF)GOTO 10
      T=PI*CV*CV
      ALPHA=(ONE+A1*T)/(T*(ONE+T*(A2+T*A3)))
      GOTO 20
   10 CONTINUE
      T=ONE-CV
      ALPHA=T*(B1+T*B2)/(ONE+T*(B3+T*B4))
   20 CONTINUE
      PARA(1)=ALPHA
      PARA(2)=XMOM(1)/ALPHA
      RETURN
C
 1000 WRITE(6,7000)
      PARA(1)=ZERO
      PARA(2)=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE PELGAM : L-MOMENTS INVALID')
      END
C===================================================== PELGEV.FOR
      SUBROUTINE PELGEV(XMOM,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C PARAMETER ESTIMATION VIA L-MOMENTS FOR THE GENERALIZED EXTREME-VALUE
C DISTRIBUTION
C
C PARAMETERS OF ROUTINE:
C XMOM * INPUT* ARRAY OF LENGTH 3. CONTAINS THE L-MOMENTS LAMBDA-1,
C LAMBDA-2, TAU-3.
C PARA *OUTPUT* ARRAY OF LENGTH 3. ON EXIT, CONTAINS THE PARAMETERS
C IN THE ORDER XI, ALPHA, K (LOCATION, SCALE, SHAPE).
C
C OTHER ROUTINES USED: DLGAMA
C
C METHOD: FOR -0.8 LE TAU3 LT 1, K IS APPROXIMATED BY RATIONAL
C FUNCTIONS AS IN DONALDSON (1996, COMMUN. STATIST. SIMUL. COMPUT.).
C IF TAU3 IS OUTSIDE THIS RANGE, NEWTON-RAPHSON ITERATION IS USED.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(3),PARA(3)
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/,TWO/2D0/,THREE/3D0/
      DATA P8/0.8D0/,P97/0.97D0/
C
C SMALL IS USED TO TEST WHETHER K IS EFFECTIVELY ZERO
C EPS,MAXIT CONTROL THE TEST FOR CONVERGENCE OF N-R ITERATION
C
      DATA SMALL/1D-5/,EPS/1D-6/,MAXIT/20/
C
C EU IS EULER'S CONSTANT
C DL2 IS LOG(2), DL3 IS LOG(3)
C
      DATA EU/0.57721566D0/,DL2/0.69314718D0/,DL3/1.0986123D0/
C
C COEFFICIENTS OF RATIONAL-FUNCTION APPROXIMATIONS FOR K
C
      DATA A0,A1,A2/ 0.28377530D0,-1.21096399D0,-2.50728214D0/
      DATA A3,A4 /-1.13455566D0,-0.07138022D0/
      DATA B1,B2,B3/ 2.06189696D0, 1.31912239D0, 0.25077104D0/
      DATA C1,C2,C3/ 1.59921491D0,-0.48832213D0, 0.01573152D0/
      DATA D1,D2 /-0.64363929D0, 0.08985247D0/
C
      T3=XMOM(3)
      IF(XMOM(2).LE.ZERO)GOTO 1000
      IF(DABS(T3).GE.ONE)GOTO 1000
      IF(T3.LE.ZERO)GOTO 10
C
C RATIONAL-FUNCTION APPROXIMATION FOR TAU3 BETWEEN 0 AND 1
C
      Z=ONE-T3
      G=(-ONE+Z*(C1+Z*(C2+Z*C3)))/(ONE+Z*(D1+Z*D2))
      IF(DABS(G).LT.SMALL)GOTO 50
      GOTO 40
C
C RATIONAL-FUNCTION APPROXIMATION FOR TAU3 BETWEEN -0.8 AND 0
C
   10 G=(A0+T3*(A1+T3*(A2+T3*(A3+T3*A4))))/(ONE+T3*(B1+T3*(B2+T3*B3)))
      IF(T3.GE.-P8)GOTO 40
C
C NEWTON-RAPHSON ITERATION FOR TAU3 LESS THAN -0.8
C
      IF(T3.LE.-P97)G=ONE-DLOG(ONE+T3)/DL2
      T0=(T3+THREE)*HALF
      DO 20 IT=1,MAXIT
      X2=TWO**(-G)
      X3=THREE**(-G)
      XX2=ONE-X2
      XX3=ONE-X3
      T=XX3/XX2
      DERIV=(XX2*X3*DL3-XX3*X2*DL2)/(XX2*XX2)
      GOLD=G
      G=G-(T-T0)/DERIV
      IF(DABS(G-GOLD).LE.EPS*G)GOTO 30
   20 CONTINUE
      WRITE(6,7010)
   30 CONTINUE
C
C ESTIMATE ALPHA,XI
C
   40 PARA(3)=G
      GAM=DEXP(DLGAMA(ONE+G))
      PARA(2)=XMOM(2)*G/(GAM*(ONE-TWO**(-G)))
      PARA(1)=XMOM(1)-PARA(2)*(ONE-GAM)/G
      RETURN
C
C ESTIMATED K EFFECTIVELY ZERO
C
   50 PARA(3)=ZERO
      PARA(2)=XMOM(2)/DL2
      PARA(1)=XMOM(1)-EU*PARA(2)
      RETURN
C
 1000 WRITE(6,7000)
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE PELGEV : L-MOMENTS INVALID')
 7010 FORMAT(' ** WARNING ** ROUTINE PELGEV :',
     * ' ITERATION HAS NOT CONVERGED. RESULTS MAY BE UNRELIABLE.')
      END
C===================================================== PELGLO.FOR
      SUBROUTINE PELGLO(XMOM,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C PARAMETER ESTIMATION VIA L-MOMENTS FOR THE GENERALIZED LOGISTIC
C DISTRIBUTION
C
C PARAMETERS OF ROUTINE:
C XMOM * INPUT* ARRAY OF LENGTH 3. CONTAINS THE L-MOMENTS LAMBDA-1,
C LAMBDA-2, TAU-3.
C PARA *OUTPUT* ARRAY OF LENGTH 3. ON EXIT, CONTAINS THE PARAMETERS
C IN THE ORDER XI, ALPHA, K (LOCATION, SCALE, SHAPE).
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(3),PARA(3)
      DATA ZERO/0D0/,ONE/1D0/
      DATA PI/3.141592653589793238D0/
C
C SMALL IS USED TO TEST WHETHER K IS EFFECTIVELY ZERO
C
      DATA SMALL/1D-6/
C
C ESTIMATE K
C
      G=-XMOM(3)
      IF(XMOM(2).LE.ZERO.OR.DABS(G).GE.ONE)GOTO 1000
      IF(DABS(G).LE.SMALL)GOTO 10
C
C ESTIMATE ALPHA, XI
C
      GG=G*PI/DSIN(G*PI)
      A=XMOM(2)/GG
      PARA(1)=XMOM(1)-A*(ONE-GG)/G
      PARA(2)=A
      PARA(3)=G
      RETURN
C
C ESTIMATED K EFFECTIVELY ZERO
C
   10 PARA(3)=ZERO
      PARA(2)=XMOM(2)
      PARA(1)=XMOM(1)
      RETURN
C
 1000 WRITE(6,7000)
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE PELGLO : L-MOMENTS INVALID')
      END
C===================================================== PELGNO.FOR
      SUBROUTINE PELGNO(XMOM,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C PARAMETER ESTIMATION VIA L-MOMENTS FOR THE GENERALIZED NORMAL
C DISTRIBUTION
C
C PARAMETERS OF ROUTINE:
C XMOM * INPUT* ARRAY OF LENGTH 3. CONTAINS THE L-MOMENTS LAMBDA-1,
C LAMBDA-2, TAU-3. ABS(TAU3) MAY NOT EXCEED 0.95.
C PARA *OUTPUT* ARRAY OF LENGTH 3. ON EXIT, CONTAINS THE PARAMETERS
C IN THE ORDER XI, ALPHA, K (LOCATION, SCALE, SHAPE).
C
C OTHER ROUTINES USED: DERF
C
C METHOD: RATIONAL-FUNCTION APPROXIMATION OF K IN TERMS OF TAU-3
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(3),PARA(3)
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/
      DATA P95/0.95D0/
      DATA ROOTPI/1.772453850905516027D0/
C
C COEFFICIENTS OF RATIONAL-FUNCTION APPROXIMATION
C A0 IS 0.5*SQRT(3/PI)
C
      DATA A0,A1,A2,A3/
     * 0.20466534D+01,-0.36544371D+01,0.18396733D+01,-0.20360244D+00/
      DATA B1,B2,B3/-0.20182173D+01,0.12420401D+01,-0.21741801D+00/
C
C SMALL IS USED TO TEST WHETHER SKEWNESS IS EFFECTIVELY ZERO
C
      DATA SMALL/1D-8/
C
      T3=XMOM(3)
      IF(XMOM(2).LE.ZERO.OR.DABS(T3).GE.ONE)GOTO 1000
      IF(DABS(T3).GE.P95)GOTO 1010
      IF(DABS(T3).LE.SMALL)GOTO 30
C
      TT=T3*T3
      G=-T3*(A0+TT*(A1+TT*(A2+TT*A3)))/(ONE+TT*(B1+TT*(B2+TT*B3)))
      E=DEXP(HALF*G*G)
      A=XMOM(2)*G/(E*DERF(HALF*G))
      U=XMOM(1)+A*(E-ONE)/G
      PARA(1)=U
      PARA(2)=A
      PARA(3)=G
      RETURN
C
   30 PARA(1)=XMOM(1)
      PARA(2)=XMOM(2)*ROOTPI
      PARA(3)=ZERO
      RETURN
C
 1000 WRITE(6,7000)
      RETURN
 1010 WRITE(6,7010)
      PARA(1)=ZERO
      PARA(2)=-ONE
      PARA(3)=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE PELGNO : L-MOMENTS INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE PELGNO :',
     * ' TAU-3 TOO LARGE FOR ROUTINE')
      END
C===================================================== PELGPA.FOR
      SUBROUTINE PELGPA(XMOM,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C PARAMETER ESTIMATION VIA L-MOMENTS FOR THE GENERALIZED PARETO
C DISTRIBUTION
C
C PARAMETERS OF ROUTINE:
C XMOM * INPUT* ARRAY OF LENGTH 3. CONTAINS THE L-MOMENTS LAMBDA-1,
C LAMBDA-2, TAU-3.
C PARA *OUTPUT* ARRAY OF LENGTH 3. ON EXIT, CONTAINS THE PARAMETERS
C IN THE ORDER XI, ALPHA, K (LOCATION, SCALE, SHAPE).
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(3),PARA(3)
      DATA ZERO/0D0/,ONE/1D0/,TWO/2D0/,THREE/3D0/
C
      T3=XMOM(3)
      IF(XMOM(2).LE.ZERO)GOTO 1000
      IF(DABS(T3).GE.ONE)GOTO 1000
      G=(ONE-THREE*T3)/(ONE+T3)
      PARA(3)=G
      PARA(2)=(ONE+G)*(TWO+G)*XMOM(2)
      PARA(1)=XMOM(1)-PARA(2)/(ONE+G)
      RETURN
C
 1000 WRITE(6,7000)
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE PELGPA : L-MOMENTS INVALID')
      END
C===================================================== PELGUM.FOR
      SUBROUTINE PELGUM(XMOM,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C PARAMETER ESTIMATION VIA L-MOMENTS FOR THE GUMBEL DISTRIBUTION
C
C PARAMETERS OF ROUTINE:
C XMOM * INPUT* ARRAY OF LENGTH 2. CONTAINS THE L-MOMENTS LAMBDA-1,
C LAMBDA-2.
C PARA *OUTPUT* ARRAY OF LENGTH 2. ON EXIT, CONTAINS THE PARAMETERS
C IN THE ORDER XI, ALPHA (LOCATION, SCALE).
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(2),PARA(2)
      DATA ZERO/0D0/
C
C EU IS EULER'S CONSTANT, DL2 IS LOG(2)
C
      DATA EU/0.577215664901532861D0/,DL2/0.693147180559945309D0/
C
      IF(XMOM(2).LE.ZERO)GOTO 1000
      PARA(2)=XMOM(2)/DL2
      PARA(1)=XMOM(1)-EU*PARA(2)
      RETURN
C
 1000 WRITE(6,7000)
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE PELGUM : L-MOMENTS INVALID')
      END
C===================================================== PELKAP.FOR
      SUBROUTINE PELKAP(XMOM,PARA,IFAIL)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C PARAMETER ESTIMATION VIA L-MOMENTS FOR THE KAPPA DISTRIBUTION
C
C PARAMETERS OF ROUTINE:
C XMOM * INPUT* ARRAY OF LENGTH 4. CONTAINS THE L-MOMENTS LAMBDA-1,
C LAMBDA-2, TAU-3, TAU-4.
C PARA *OUTPUT* ARRAY OF LENGTH 4. ON EXIT, CONTAINS THE PARAMETERS
C IN THE ORDER XI, ALPHA, K, H.
C IFAIL *OUTPUT* FAIL FLAG. ON EXIT, IT IS SET AS FOLLOWS.
C 0 SUCCESSFUL EXIT
C 1 L-MOMENTS INVALID
C 2 (TAU-3, TAU-4) LIES ABOVE THE GENERALIZED-LOGISTIC
C LINE (SUGGESTS THAT L-MOMENTS ARE NOT CONSISTENT
C WITH ANY KAPPA DISTRIBUTION WITH H.GT.-1)
C 3 ITERATION FAILED TO CONVERGE
C 4 UNABLE TO MAKE PROGRESS FROM CURRENT POINT IN
C ITERATION
C 5 ITERATION ENCOUNTERED NUMERICAL DIFFICULTIES -
C OVERFLOW WOULD HAVE BEEN LIKELY TO OCCUR
C 6 ITERATION FOR H AND K CONVERGED, BUT OVERFLOW
C WOULD HAVE OCCURRED WHEN CALCULATING XI AND ALPHA
C
C N.B. PARAMETERS ARE SOMETIMES NOT UNIQUELY DEFINED BY THE FIRST 4
C L-MOMENTS. IN SUCH CASES THE ROUTINE RETURNS THE SOLUTION FOR WHICH
C THE H PARAMETER IS LARGEST.
C
C OTHER ROUTINES USED: DLGAMA,DIGAMD
C
C THE SHAPE PARAMETERS K AND H ARE ESTIMATED USING NEWTON-RAPHSON
C ITERATION ON THE RELATIONSHIP BETWEEN (TAU-3,TAU-4) AND (K,H).
C THE CONVERGENCE CRITERION IS THAT TAU-3 AND TAU-4 CALCULATED FROM
C THE ESTIMATED VALUES OF K AND H SHOULD DIFFER BY LESS THAN 'EPS'
C FROM THE VALUES SUPPLIED IN ARRAY XMOM.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(4),PARA(4)
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/,TWO/2D0/,THREE/3D0/,FOUR/4D0/
      DATA FIVE/5D0/,SIX/6D0/,TWELVE/12D0/,TWENTY/20D0/,THIRTY/30D0/
      DATA P725/0.725D0/,P8/0.8D0/
C
C EPS,MAXIT CONTROL THE TEST FOR CONVERGENCE OF N-R ITERATION
C MAXSR IS THE MAX. NO. OF STEPLENGTH REDUCTIONS PER ITERATION
C HSTART IS THE STARTING VALUE FOR H
C BIG IS USED TO INITIALIZE THE CRITERION FUNCTION
C OFLEXP IS SUCH THAT DEXP(OFLEXP) JUST DOES NOT CAUSE OVERFLOW
C OFLGAM IS SUCH THAT DEXP(DLGAMA(OFLGAM)) JUST DOES NOT CAUSE
C OVERFLOW
C
      DATA EPS/1D-6/,MAXIT/20/,MAXSR/10/,HSTART/1.001D0/,BIG/10D0/
      DATA OFLEXP/170D0/,OFLGAM/53D0/
C
      T3=XMOM(3)
      T4=XMOM(4)
      DO 10 I=1,4
   10 PARA(I)=ZERO
C
C TEST FOR FEASIBILITY
C
      IF(XMOM(2).LE.ZERO)GOTO 1000
      IF(DABS(T3).GE.ONE.OR.DABS(T4).GE.ONE)GOTO 1000
      IF(T4.LE.(FIVE*T3*T3-ONE)/FOUR)GOTO 1000
      IF(T4.GE.(FIVE*T3*T3+ONE)/SIX )GOTO 1010
C
C SET STARTING VALUES FOR N-R ITERATION:
C G IS CHOSEN TO GIVE THE CORRECT VALUE OF TAU-3 ON THE
C ASSUMPTION THAT H=1 (I.E. A GENERALIZED PARETO FIT) -
C BUT H IS ACTUALLY SET TO 1.001 TO AVOID NUMERICAL
C DIFFICULTIES WHICH CAN SOMETIMES ARISE WHEN H=1 EXACTLY
C
      G=(ONE-THREE*T3)/(ONE+T3)
      H=HSTART
      Z=G+H*P725
      XDIST=BIG
C
C START OF NEWTON-RAPHSON ITERATION
C
      DO 100 IT=1,MAXIT
C
C REDUCE STEPLENGTH UNTIL WE ARE NEARER TO THE REQUIRED
C VALUES OF TAU-3 AND TAU-4 THAN WE WERE AT THE PREVIOUS STEP
C
      DO 40 I=1,MAXSR
C
C - CALCULATE CURRENT TAU-3 AND TAU-4
C
C NOTATION:
C U. - RATIOS OF GAMMA FUNCTIONS WHICH OCCUR IN THE PWM'S
C BETA-SUB-R
C ALAM. - L-MOMENTS (APART FROM A LOCATION AND SCALE SHIFT)
C TAU. - L-MOMENT RATIOS
C
      IF(G.GT.OFLGAM)GOTO 1020
      IF(H.GT.ZERO)GOTO 20
      U1=DEXP(DLGAMA( -ONE/H-G)-DLGAMA( -ONE/H+ONE))
      U2=DEXP(DLGAMA( -TWO/H-G)-DLGAMA( -TWO/H+ONE))
      U3=DEXP(DLGAMA(-THREE/H-G)-DLGAMA(-THREE/H+ONE))
      U4=DEXP(DLGAMA( -FOUR/H-G)-DLGAMA( -FOUR/H+ONE))
      GOTO 30
   20 U1=DEXP(DLGAMA( ONE/H)-DLGAMA( ONE/H+ONE+G))
      U2=DEXP(DLGAMA( TWO/H)-DLGAMA( TWO/H+ONE+G))
      U3=DEXP(DLGAMA(THREE/H)-DLGAMA(THREE/H+ONE+G))
      U4=DEXP(DLGAMA( FOUR/H)-DLGAMA( FOUR/H+ONE+G))
   30 CONTINUE
      ALAM2=U1-TWO*U2
      ALAM3=-U1+SIX*U2-SIX*U3
      ALAM4=U1-TWELVE*U2+THIRTY*U3-TWENTY*U4
      IF(ALAM2.EQ.ZERO)GOTO 1020
      TAU3=ALAM3/ALAM2
      TAU4=ALAM4/ALAM2
      E1=TAU3-T3
      E2=TAU4-T4
C
C - IF NEARER THAN BEFORE, EXIT THIS LOOP
C
      DIST=DMAX1(DABS(E1),DABS(E2))
      IF(DIST.LT.XDIST)GOTO 50
C
C - OTHERWISE, HALVE THE STEPLENGTH AND TRY AGAIN
C
      DEL1=HALF*DEL1
      DEL2=HALF*DEL2
      G=XG-DEL1
      H=XH-DEL2
   40 CONTINUE
C
C TOO MANY STEPLENGTH REDUCTIONS
C
      IFAIL=4
      RETURN
C
C TEST FOR CONVERGENCE
C
   50 CONTINUE
      IF(DIST.LT.EPS)GOTO 110
C
C NOT CONVERGED: CALCULATE NEXT STEP
C
C NOTATION:
C U1G - DERIVATIVE OF U1 W.R.T. G
C DL2G - DERIVATIVE OF ALAM2 W.R.T. G
C D.. - MATRIX OF DERIVATIVES OF TAU-3 AND TAU-4 W.R.T. G AND H
C H.. - INVERSE OF DERIVATIVE MATRIX
C DEL. - STEPLENGTH
C
      XG=G
      XH=H
      XZ=Z
      XDIST=DIST
      RHH=ONE/(H*H)
      IF(H.GT.ZERO)GOTO 60
      U1G=-U1*DIGAMD( -ONE/H-G)
      U2G=-U2*DIGAMD( -TWO/H-G)
      U3G=-U3*DIGAMD(-THREE/H-G)
      U4G=-U4*DIGAMD( -FOUR/H-G)
      U1H= RHH*(-U1G-U1*DIGAMD( -ONE/H+ONE))
      U2H= TWO*RHH*(-U2G-U2*DIGAMD( -TWO/H+ONE))
      U3H=THREE*RHH*(-U3G-U3*DIGAMD(-THREE/H+ONE))
      U4H= FOUR*RHH*(-U4G-U4*DIGAMD( -FOUR/H+ONE))
      GOTO 70
   60 U1G=-U1*DIGAMD( ONE/H+ONE+G)
      U2G=-U2*DIGAMD( TWO/H+ONE+G)
      U3G=-U3*DIGAMD(THREE/H+ONE+G)
      U4G=-U4*DIGAMD( FOUR/H+ONE+G)
      U1H= RHH*(-U1G-U1*DIGAMD( ONE/H))
      U2H= TWO*RHH*(-U2G-U2*DIGAMD( TWO/H))
      U3H=THREE*RHH*(-U3G-U3*DIGAMD(THREE/H))
      U4H= FOUR*RHH*(-U4G-U4*DIGAMD( FOUR/H))
   70 CONTINUE
      DL2G=U1G-TWO*U2G
      DL2H=U1H-TWO*U2H
      DL3G=-U1G+SIX*U2G-SIX*U3G
      DL3H=-U1H+SIX*U2H-SIX*U3H
      DL4G=U1G-TWELVE*U2G+THIRTY*U3G-TWENTY*U4G
      DL4H=U1H-TWELVE*U2H+THIRTY*U3H-TWENTY*U4H
      D11=(DL3G-TAU3*DL2G)/ALAM2
      D12=(DL3H-TAU3*DL2H)/ALAM2
      D21=(DL4G-TAU4*DL2G)/ALAM2
      D22=(DL4H-TAU4*DL2H)/ALAM2
      DET=D11*D22-D12*D21
      H11= D22/DET
      H12=-D12/DET
      H21=-D21/DET
      H22= D11/DET
      DEL1=E1*H11+E2*H12
      DEL2=E1*H21+E2*H22
C
C TAKE NEXT N-R STEP
C
      G=XG-DEL1
      H=XH-DEL2
      Z=G+H*P725
C
C REDUCE STEP IF G AND H ARE OUTSIDE THE PARAMETER SPACE
C
      FACTOR=ONE
      IF(G.LE.-ONE)FACTOR=P8*(XG+ONE)/DEL1
      IF(H.LE.-ONE)FACTOR=DMIN1(FACTOR,P8*(XH+ONE)/DEL2)
      IF(Z.LE.-ONE)FACTOR=DMIN1(FACTOR,P8*(XZ+ONE)/(XZ-Z))
      IF(H.LE.ZERO.AND.G*H.LE.-ONE)
     * FACTOR=DMIN1(FACTOR,P8*(XG*XH+ONE)/(XG*XH-G*H))
      IF(FACTOR.EQ.ONE)GOTO 80
      DEL1=DEL1*FACTOR
      DEL2=DEL2*FACTOR
      G=XG-DEL1
      H=XH-DEL2
      Z=G+H*P725
   80 CONTINUE
C
C END OF NEWTON-RAPHSON ITERATION
C
  100 CONTINUE
C
C NOT CONVERGED
C
      IFAIL=3
      RETURN
C
C CONVERGED
C
  110 IFAIL=0
      PARA(4)=H
      PARA(3)=G
      TEMP=DLGAMA(ONE+G)
      IF(TEMP.GT.OFLEXP)GOTO 1030
      GAM=DEXP(TEMP)
      TEMP=(ONE+G)*DLOG(DABS(H))
      IF(TEMP.GT.OFLEXP)GOTO 1030
      HH=DEXP(TEMP)
      PARA(2)=XMOM(2)*G*HH/(ALAM2*GAM)
      PARA(1)=XMOM(1)-PARA(2)/G*(ONE-GAM*U1/HH)
      RETURN
C
 1000 IFAIL=1
      RETURN
 1010 IFAIL=2
      RETURN
 1020 IFAIL=5
      RETURN
 1030 IFAIL=6
      RETURN
C
      END
C===================================================== PELNOR.FOR
      SUBROUTINE PELNOR(XMOM,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C PARAMETER ESTIMATION VIA L-MOMENTS FOR THE NORMAL DISTRIBUTION
C
C PARAMETERS OF ROUTINE:
C XMOM * INPUT* ARRAY OF LENGTH 2. CONTAINS THE L-MOMENTS LAMBDA-1,
C LAMBDA-2.
C PARA *OUTPUT* ARRAY OF LENGTH 2. ON EXIT, CONTAINS THE PARAMETERS
C IN THE ORDER MU, SIGMA (LOCATION, SCALE).
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(2),PARA(2)
      DATA ZERO/0D0/
      DATA ROOTPI/1.7724 53850 90551 603D0/
C
      IF(XMOM(2).LE.ZERO)GOTO 1000
      PARA(2)=XMOM(2)*ROOTPI
      PARA(1)=XMOM(1)
      RETURN
C
 1000 WRITE(6,7000)
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE PELNOR : L-MOMENTS INVALID')
      END
C===================================================== PELPE3.FOR
      SUBROUTINE PELPE3(XMOM,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C PARAMETER ESTIMATION VIA L-MOMENTS FOR THE PEARSON TYPE 3 DISTRIBUTION
C
C PARAMETERS OF ROUTINE:
C XMOM * INPUT* ARRAY OF LENGTH 3. CONTAINS THE L-MOMENTS LAMBDA-1,
C LAMBDA-2 AND TAU-3.
C PARA *OUTPUT* ARRAY OF LENGTH 3. ON EXIT, CONTAINS THE PARAMETERS
C IN THE ORDER MU, SIGMA, GAMMA (MEAN, S.D., SKEWNESS).
C
C OTHER ROUTINES USED: DLGAMA
C
C METHOD: RATIONAL APPROXIMATION IS USED TO EXPRESS ALPHA, THE SHAPE
C PARAMETER OF THE GAMMA DISTRIBUTION, AS A FUNCTION OF TAU-3.
C RELATIVE ACCURACY OF THE APPROXIMATION IS BETTER THAN 3E-5.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(3),PARA(3)
      DATA ZERO/0D0/,THIRD/0.33333333D0/,HALF/0.5D0/,ONE/1D0/,TWO/2D0/
C
C SMALL IS USED TO TEST WHETHER SKEWNESS IS EFFECTIVELY ZERO
C
      DATA SMALL/1D-6/
C
C CONSTANTS USED IN MINIMAX APPROXIMATIONS
C
      DATA C1,C2,C3/ 0.2906D0, 0.1882D0, 0.0442D0/
      DATA D1,D2,D3/ 0.36067D0,-0.59567D0, 0.25361D0/
      DATA D4,D5,D6/-2.78861D0, 2.56096D0,-0.77045D0/
      DATA PI3,ROOTPI/9.4247780D0,1.7724539D0/
C
      T3=DABS(XMOM(3))
      IF(XMOM(2).LE.ZERO.OR.T3.GE.ONE)GOTO 1000
      IF(T3.LE.SMALL)GOTO 100
      IF(T3.GE.THIRD)GOTO 10
      T=PI3*T3*T3
      ALPHA=(ONE+C1*T)/(T*(ONE+T*(C2+T*C3)))
      GOTO 20
   10 CONTINUE
      T=ONE-T3
      ALPHA=T*(D1+T*(D2+T*D3))/(ONE+T*(D4+T*(D5+T*D6)))
   20 CONTINUE
      RTALPH=DSQRT(ALPHA)
      BETA=ROOTPI*XMOM(2)*DEXP(DLGAMA(ALPHA)-DLGAMA(ALPHA+HALF))
      PARA(1)=XMOM(1)
      PARA(2)=BETA*RTALPH
      PARA(3)=TWO/RTALPH
      IF(XMOM(3).LT.ZERO)PARA(3)=-PARA(3)
      RETURN
C
C ZERO SKEWNESS
C
  100 CONTINUE
      PARA(1)=XMOM(1)
      PARA(2)=XMOM(2)*ROOTPI
      PARA(3)=ZERO
      RETURN
C
 1000 WRITE(6,7000)
      DO 1010 I=1,3
 1010 PARA(I)=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE PELPE3 : L-MOMENTS INVALID')
      END
C===================================================== PELWAK.FOR
      SUBROUTINE PELWAK(XMOM,PARA,IFAIL)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C PARAMETER ESTIMATION VIA L-MOMENTS FOR THE WAKEBY DISTRIBUTION
C
C PARAMETERS OF ROUTINE:
C XMOM * INPUT* ARRAY OF LENGTH 5. CONTAINS THE L-MOMENTS LAMBDA-1,
C LAMBDA-2, TAU-3, TAU-4, TAU-5.
C PARA *OUTPUT* ARRAY OF LENGTH 5. ON EXIT, CONTAINS THE PARAMETERS
C IN THE ORDER XI, ALPHA, BETA, GAMMA, DELTA.
C IFAIL *OUTPUT* FAIL FLAG. ON EXIT, IT IS SET AS FOLLOWS.
C 0 SUCCESSFUL EXIT
C 1 ESTIMATES COULD ONLY BE OBTAINED BY SETTING XI=0
C 2 ESTIMATES COULD ONLY BE OBTAINED BY FITTING A
C GENERALIZED PARETO DISTRIBUTION
C 3 L-MOMENTS INVALID
C
C PROCEDURE:
C 1. LOOK FOR A SOLUTION WITH XI UNCONSTRAINED;
C 2. IF NONE FOUND, LOOK FOR A SOLUTION WITH XI=0;
C 3. IF NONE FOUND, FIT A GENERALIZED PARETO DISTRIBUTION TO THE
C FIRST 3 L-MOMENTS.
C ESTIMATES ARE CALCULATED USING THE FORMULAS GIVEN BY GREENWOOD ET AL.
C (1979, WATER RESOUR. RES., TABLE 5), BUT EXPRESSED IN TERMS OF
C L-MOMENTS RATHER THAN PROBABILITY WEIGHTED MOMENTS.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION XMOM(5),PARA(5)
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/,TWO/2D0/,THREE/3D0/,FOUR/4D0/
      DATA X2/2D0/,X3/3D0/,X4/4D0/,X5/5D0/,X7/7D0/,X8/8D0/,X9/9D0/,
     * X10/10D0/,X11/11D0/,X16/16D0/,X25/25D0/,X29/29D0/,X32/32D0/,
     * X35/35D0/,X85/85D0/,X125/125D0/,X203/203D0/
C
      IF(DABS(XMOM(2)).LE.ZERO)GOTO 1000
      IF(DABS(XMOM(3)).GE.ONE)GOTO 1000
      IF(DABS(XMOM(4)).GE.ONE)GOTO 1000
      IF(DABS(XMOM(5)).GE.ONE)GOTO 1000
      IFAIL=0
C
C CALCULATE THE L-MOMENTS (LAMBDA'S)
C
      ALAM1=XMOM(1)
      ALAM2=XMOM(2)
      ALAM3=XMOM(3)*ALAM2
      ALAM4=XMOM(4)*ALAM2
      ALAM5=XMOM(5)*ALAM2
C
C ESTIMATE N1,N2,N3,C1,C2,C3 WHEN XI.NE.0
C
      XN1= X3*ALAM2-X25*ALAM3 +X32*ALAM4
      XN2=-X3*ALAM2 +X5*ALAM3 +X8*ALAM4
      XN3= X3*ALAM2 +X5*ALAM3 +X2*ALAM4
      XC1= X7*ALAM2-X85*ALAM3+X203*ALAM4-X125*ALAM5
      XC2=-X7*ALAM2+X25*ALAM3 +X7*ALAM4 -X25*ALAM5
      XC3= X7*ALAM2 +X5*ALAM3 -X7*ALAM4 -X5*ALAM5
C
C ESTIMATE B AND D
C
      XA=XN2*XC3-XC2*XN3
      XB=XN1*XC3-XC1*XN3
      XC=XN1*XC2-XC1*XN2
      DISC=XB*XB-FOUR*XA*XC
      IF(DISC.LT.ZERO)GOTO 10
      DISC=DSQRT(DISC)
      ROOT1=HALF*(-XB+DISC)/XA
      ROOT2=HALF*(-XB-DISC)/XA
      B= DMAX1(ROOT1,ROOT2)
      D=-DMIN1(ROOT1,ROOT2)
      IF(D.GE.ONE)GOTO 10
C
C ESTIMATE A, C AND XI
C
      A=(ONE+B)*(TWO+B)*(THREE+B)/
     * (FOUR*(B+D))*((ONE+D)*ALAM2-(THREE-D)*ALAM3)
      C=-(ONE-D)*(TWO-D)*(THREE-D)/
     * (FOUR*(B+D))*((ONE-B)*ALAM2-(THREE+B)*ALAM3)
      XI=ALAM1-A/(ONE+B)-C/(ONE-D)
C
C CHECK FOR VALID PARAMETERS
C
      IF(C.GE.ZERO.AND.A+C.GE.ZERO)GOTO 30
C
C CAN'T FIND VALID ESTIMATES FOR XI UNRESTRICTED, SO TRY XI=0
C
C ESTIMATE B AND D FOR XI=0
C
   10 IFAIL=1
      XI=ZERO
      ZN1=X4*ALAM1-X11*ALAM2+X9*ALAM3
      ZN2=-ALAM2+X3*ALAM3
      ZN3=ALAM2+ALAM3
      ZC1=X10*ALAM1-X29*ALAM2+X35*ALAM3-X16*ALAM4
      ZC2=-ALAM2+X5*ALAM3-X4*ALAM4
      ZC3=ALAM2-ALAM4
      ZA=ZN2*ZC3-ZC2*ZN3
      ZB=ZN1*ZC3-ZC1*ZN3
      ZC=ZN1*ZC2-ZC1*ZN2
      DISC=ZB*ZB-FOUR*ZA*ZC
      IF(DISC.LT.ZERO)GOTO 20
      DISC=DSQRT(DISC)
      ROOT1=HALF*(-ZB+DISC)/ZA
      ROOT2=HALF*(-ZB-DISC)/ZA
      B= DMAX1(ROOT1,ROOT2)
      D=-DMIN1(ROOT1,ROOT2)
      IF(D.GE.ONE)GOTO 20
C
C ESTIMATE A AND C
C
      A= (ONE+B)*(TWO+B)/(B+D)*(ALAM1-(TWO-D)*ALAM2)
      C=-(ONE-D)*(TWO-D)/(B+D)*(ALAM1-(TWO+B)*ALAM2)
      IF(C.GE.ZERO.AND.A+C.GE.ZERO)GOTO 30
C
C CAN'T FIND VALID ESTIMATES EVEN WITH XI=0 -
C FIT GENERALIZED PARETO DISTRIBUTION INSTEAD
C
   20 IFAIL=2
      D=-(ONE-THREE*XMOM(3))/(ONE+XMOM(3))
      C=(ONE-D)*(TWO-D)*XMOM(2)
      B=ZERO
      A=ZERO
      XI=XMOM(1)-C/(ONE-D)
      IF(D.GT.ZERO)GOTO 30
      A=C
      B=-D
      C=ZERO
      D=ZERO
C
C COPY RESULTS INTO ARRAY PARA
C
   30 PARA(1)=XI
      PARA(2)=A
      PARA(3)=B
      PARA(4)=C
      PARA(5)=D
      RETURN
C
 1000 IFAIL=3
      DO 1010 I=1,5
 1010 PARA(I)=ZERO
      END
C===================================================== QUAEXP.FOR
      DOUBLE PRECISION FUNCTION QUAEXP(F,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C QUANTILE FUNCTION OF THE EXPONENTIAL DISTRIBUTION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(2)
      DATA ZERO/0D0/,ONE/1D0/
      U=PARA(1)
      A=PARA(2)
      IF(A.LE.ZERO)GOTO 1000
      IF(F.LE.ZERO.OR.F.GE.ONE)GOTO 1010
      QUAEXP=U-A*DLOG(ONE-F)
      RETURN
C
 1000 WRITE(6,7000)
      QUAEXP=ZERO
      RETURN
 1010 WRITE(6,7010)
      QUAEXP=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUAEXP : PARAMETERS INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE QUAEXP :',
     * ' ARGUMENT OF FUNCTION INVALID')
      END
C===================================================== QUAGAM.FOR
      DOUBLE PRECISION FUNCTION QUAGAM(F,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C QUANTILE FUNCTION OF THE GAMMA DISTRIBUTION
C
C OTHER ROUTINES USED: DERF,DLGAMA,GAMIND,QUASTN
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(2)
      DATA ZERO/0D0/,P01/0.01D0/,ONE/1D0/,NINE/9D0/
C
C EPS,MAXIT CONTROL THE TEST FOR CONVERGENCE OF N-R ITERATION
C
      DATA EPS/1D-10/,MAXIT/30/
C
      QUAGAM=ZERO
      ALPHA=PARA(1)
      BETA=PARA(2)
      IF(ALPHA.LE.ZERO.OR.BETA.LE.ZERO)GOTO 1000
      IF(F.LT.ZERO.OR.F.GE.ONE)GOTO 1010
      IF(F.EQ.ZERO)RETURN
      AM1=ALPHA-ONE
      IF(AM1.NE.ZERO)GOTO 10
C
C CASE ALPHA.EQ.1 - GAMMA IS EXPONENTIAL
C
      QUAGAM=(-DLOG(ONE-F))*BETA
      RETURN
C
C INITIAL ESTIMATE OF ROOT OF EQUATION GAMIND(X)=F:
C - IF ALPHA.GT.1, USE WILSON-HILFERTY APPROXIMATION IF IT'S
C POSITIVE AND NOT TOO CLOSE TO ZERO;
C - IF ALPHA.LT.1, OR IF W-H APPROX. ISN'T POSITIVE ENOUGH,
C USE THE SMALL-X APPROXIMATION OF IGNORING THE EXP(-T) TERM
C IN THE INTEGRAL DEFINING GAMIND(X)
C
   10 DLOGG=DLGAMA(ALPHA)
      IF(AM1.LE.ZERO)GOTO 20
      ROOT=ALPHA*(ONE-ONE/(NINE*ALPHA)+QUASTN(F)/DSQRT(NINE*ALPHA))**3
      IF(ROOT.GT.P01*ALPHA)GOTO 30
   20 ROOT=DEXP((DLOG(ALPHA*F)+DLOGG)/ALPHA)
   30 CONTINUE
C
C REFINE INITIAL ESTIMATE BY NEWTON-RAPHSON ITERATION
C
      DO 40 IT=1,MAXIT
      FUNC=GAMIND(ROOT,ALPHA,DLOGG)-F
      RINC=FUNC*DEXP(DLOGG+ROOT-AM1*DLOG(ROOT))
      ROOT=ROOT-RINC
      IF(DABS(FUNC).LE.EPS)GOTO 50
   40 CONTINUE
      WRITE(6,7020)
C
C SCALE SOLUTION
C
   50 QUAGAM=ROOT*BETA
      RETURN
C
 1000 WRITE(6,7000)
      RETURN
 1010 WRITE(6,7010)
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUAGAM : PARAMETERS INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE QUAGAM :',
     * ' ARGUMENT OF FUNCTION INVALID')
 7020 FORMAT(' ** WARNING ** ROUTINE QUAGAM :',
     * ' ITERATION HAS NOT CONVERGED. RESULT MAY BE UNRELIABLE')
      END
C===================================================== QUAGEV.FOR
      DOUBLE PRECISION FUNCTION QUAGEV(F,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C QUANTILE FUNCTION OF THE GENERALIZED EXTREME-VALUE DISTRIBUTION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(3)
      DATA ZERO/0D0/,ONE/1D0/
      U=PARA(1)
      A=PARA(2)
      G=PARA(3)
      IF(A.LE.ZERO)GOTO 1000
      IF(F.LE.ZERO.OR.F.GE.ONE)GOTO 10
      Y=-DLOG(-DLOG(F))
      IF(G.NE.ZERO)Y=(ONE-DEXP(-G*Y))/G
      QUAGEV=U+A*Y
      RETURN
C
   10 IF(F.EQ.ZERO.AND.G.LT.ZERO)GOTO 20
      IF(F.EQ.ONE .AND.G.GT.ZERO)GOTO 20
      WRITE(6,7000)
      QUAGEV=ZERO
      RETURN
   20 QUAGEV=U+A/G
      RETURN
C
 1000 WRITE(6,7010)
      QUAGEV=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUAGEV :',
     * ' ARGUMENT OF FUNCTION INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE QUAGEV : PARAMETERS INVALID')
      END
C===================================================== QUAGLO.FOR
      DOUBLE PRECISION FUNCTION QUAGLO(F,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C QUANTILE FUNCTION OF THE GENERALIZED LOGISTIC DISTRIBUTION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(3)
      DATA ZERO/0D0/,ONE/1D0/
      U=PARA(1)
      A=PARA(2)
      G=PARA(3)
      IF(A.LE.ZERO)GOTO 1000
      IF(F.LE.ZERO.OR.F.GE.ONE)GOTO 10
      Y=DLOG(F/(ONE-F))
      IF(G.NE.ZERO)Y=(ONE-DEXP(-G*Y))/G
      QUAGLO=U+A*Y
      RETURN
C
   10 IF(F.EQ.ZERO.AND.G.LT.ZERO)GOTO 20
      IF(F.EQ.ONE .AND.G.GT.ZERO)GOTO 20
      WRITE(6,7000)
      QUAGLO=ZERO
      RETURN
   20 QUAGLO=U+A/G
      RETURN
C
 1000 WRITE(6,7010)
      QUAGLO=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUAGLO :',
     * ' ARGUMENT OF FUNCTION INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE QUAGLO : PARAMETERS INVALID')
      END
C===================================================== QUAGNO.FOR
      DOUBLE PRECISION FUNCTION QUAGNO(F,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C QUANTILE FUNCTION OF THE GENERALIZED NORMAL DISTRIBUTION
C
C OTHER ROUTINES USED: QUASTN
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(3)
      DATA ZERO/0D0/,ONE/1D0/
      U=PARA(1)
      A=PARA(2)
      G=PARA(3)
      IF(A.LE.ZERO)GOTO 1000
      IF(F.LE.ZERO.OR.F.GE.ONE)GOTO 10
      Y=QUASTN(F)
      IF(G.NE.ZERO)Y=(ONE-DEXP(-G*Y))/G
      QUAGNO=U+A*Y
      RETURN
C
   10 IF(F.EQ.ZERO.AND.G.LT.ZERO)GOTO 20
      IF(F.EQ.ONE .AND.G.GT.ZERO)GOTO 20
      WRITE(6,7000)
      QUAGNO=ZERO
      RETURN
   20 QUAGNO=U+A/G
      RETURN
C
 1000 WRITE(6,7010)
      QUAGNO=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUAGNO :',
     * ' ARGUMENT OF FUNCTION INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE QUAGNO : PARAMETERS INVALID')
      END
C===================================================== QUAGPA.FOR
      DOUBLE PRECISION FUNCTION QUAGPA(F,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C QUANTILE FUNCTION OF THE GENERALIZED PARETO DISTRIBUTION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(3)
      DATA ZERO/0D0/,ONE/1D0/
      U=PARA(1)
      A=PARA(2)
      G=PARA(3)
      IF(A.LE.ZERO)GOTO 1000
      IF(F.LE.ZERO.OR.F.GE.ONE)GOTO 10
      Y=-DLOG(ONE-F)
      IF(G.NE.ZERO)Y=(ONE-DEXP(-G*Y))/G
      QUAGPA=U+A*Y
      RETURN
C
   10 IF(F.EQ.ZERO)QUAGPA=U
      IF(F.EQ.ZERO)RETURN
      IF(F.EQ.ONE.AND.G.GT.ZERO)QUAGPA=U+A/G
      IF(F.EQ.ONE.AND.G.GT.ZERO)RETURN
      WRITE(6,7000)
      QUAGPA=ZERO
      RETURN
C
 1000 WRITE(6,7010)
      QUAGPA=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUAGPA :',
     * ' ARGUMENT OF FUNCTION INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE QUAGPA : PARAMETERS INVALID')
      END

C===================================================== QUAGUM.FOR
      DOUBLE PRECISION FUNCTION QUAGUM(F,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C QUANTILE FUNCTION OF THE GUMBEL DISTRIBUTION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(2)
      DATA ZERO/0D0/,ONE/1D0/
      U=PARA(1)
      A=PARA(2)
      IF(A.LE.ZERO)GOTO 1000
      IF(F.LE.ZERO.OR.F.GE.ONE)GOTO 1010
      QUAGUM=U-A*DLOG(-DLOG(F))
      RETURN
C
 1000 WRITE(6,7000)
      QUAGUM=ZERO
      RETURN
 1010 WRITE(6,7010)
      QUAGUM=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUAGUM : PARAMETERS INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE QUAGUM :',
     * ' ARGUMENT OF FUNCTION INVALID')
      END
C===================================================== QUAKAP.FOR
      DOUBLE PRECISION FUNCTION QUAKAP(F,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C QUANTILE FUNCTION OF THE KAPPA DISTRIBUTION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(4)
      DATA ZERO/0D0/,ONE/1D0/
      U=PARA(1)
      A=PARA(2)
      G=PARA(3)
      H=PARA(4)
      IF(A.LE.ZERO)GOTO 1000
      IF(F.LE.ZERO.OR.F.GE.ONE)GOTO 10
      Y=-DLOG(F)
      IF(H.NE.ZERO)Y=(ONE-DEXP(-H*Y))/H
      Y=-DLOG(Y)
      IF(G.NE.ZERO)Y=(ONE-DEXP(-G*Y))/G
      QUAKAP=U+A*Y
      RETURN
C
   10 IF(F.EQ.ZERO)GOTO 20
      IF(F.EQ.ONE)GOTO 30
      GOTO 1010
   20 IF(H.LE.ZERO.AND.G.LT.ZERO)QUAKAP=U+A/G
      IF(H.LE.ZERO.AND.G.GE.ZERO)GOTO 1010
      IF(H.GT.ZERO.AND.G.NE.ZERO)QUAKAP=U+A/G*(ONE-H**(-G))
      IF(H.GT.ZERO.AND.G.EQ.ZERO)QUAKAP=U+A*DLOG(H)
      RETURN
   30 IF(G.LE.ZERO)GOTO 1010
      QUAKAP=U+A/G
      RETURN
C
 1000 WRITE(6,7000)
      QUAKAP=ZERO
      RETURN
 1010 WRITE(6,7010)
      QUAKAP=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUAKAP : PARAMETERS INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE QUAKAP :',
     * ' ARGUMENT OF FUNCTION INVALID')
      END
C===================================================== QUANOR.FOR
      DOUBLE PRECISION FUNCTION QUANOR(F,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C QUANTILE FUNCTION OF THE NORMAL DISTRIBUTION
C
C OTHER ROUTINES USED: QUASTN
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(2)
      DATA ZERO/0D0/,ONE/1D0/
      IF(PARA(2).LE.ZERO)GOTO 1000
      IF(F.LE.ZERO.OR.F.GE.ONE)GOTO 1010
      QUANOR=PARA(1)+PARA(2)*QUASTN(F)
      RETURN
C
 1000 WRITE(6,7000)
      QUANOR=ZERO
      RETURN
 1010 WRITE(6,7010)
      QUANOR=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUANOR : PARAMETERS INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE QUANOR :',
     * ' ARGUMENT OF FUNCTION INVALID')
      END
C===================================================== QUAPE3.FOR
      DOUBLE PRECISION FUNCTION QUAPE3(F,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C QUANTILE FUNCTION OF THE PEARSON TYPE 3 DISTRIBUTION
C
C OTHER ROUTINES USED: DERF,DLGAMA,GAMIND,QUAGAM,QUASTN
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(3),PAR(2)
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/,TWO/2D0/,FOUR/4D0/
C
C SMALL IS USED TO TEST WHETHER SKEWNESS IS EFFECTIVELY ZERO
C
      DATA SMALL/1D-6/
C
      IF(PARA(2).LE.ZERO)GOTO 1000
      GAMMA=PARA(3)
      IF(F.LE.ZERO.OR.F.GE.ONE)GOTO 20
      IF(DABS(GAMMA).LT.SMALL)GOTO 10
      ALPHA=FOUR/(GAMMA*GAMMA)
      BETA=DABS(HALF*PARA(2)*GAMMA)
      PAR(1)=ALPHA
      PAR(2)=BETA
      IF(GAMMA.GT.ZERO)QUAPE3=PARA(1)-ALPHA*BETA+QUAGAM(F,PAR)
      IF(GAMMA.LT.ZERO)QUAPE3=PARA(1)+ALPHA*BETA-QUAGAM(ONE-F,PAR)
      RETURN
C
C ZERO SKEWNESS
C
   10 QUAPE3=PARA(1)+PARA(2)*QUASTN(F)
      RETURN
C
   20 IF(F.EQ.ZERO.AND.GAMMA.GT.ZERO)GOTO 30
      IF(F.EQ.ONE .AND.GAMMA.LT.ZERO)GOTO 30
      WRITE(6,7000)
      QUAPE3=ZERO
      RETURN
   30 QUAPE3=PARA(1)-TWO*PARA(2)/GAMMA
      RETURN
C
 1000 WRITE(6,7010)
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUAPE3 :',
     * ' ARGUMENT OF FUNCTION INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE QUAPE3 : PARAMETERS INVALID')
      END
C===================================================== QUAWAK.FOR
      DOUBLE PRECISION FUNCTION QUAWAK(F,PARA)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C QUANTILE FUNCTION OF THE WAKEBY DISTRIBUTION
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION PARA(5)
      DATA ZERO/0D0/,ONE/1D0/
C
C UFL SHOULD BE CHOSEN SO THAT EXP(UFL) JUST DOES NOT CAUSE
C UNDERFLOW
C
      DATA UFL/-170D0/
C
      XI=PARA(1)
      A=PARA(2)
      B=PARA(3)
      C=PARA(4)
      D=PARA(5)
C
C TEST FOR VALID PARAMETERS
C
      IF(B+D.LE.ZERO.AND.(B.NE.ZERO.OR.C.NE.ZERO.OR.D.NE.ZERO))GOTO 1000
      IF(A.EQ.ZERO.AND.B.NE.ZERO)GOTO 1000
      IF(C.EQ.ZERO.AND.D.NE.ZERO)GOTO 1000
      IF(C.LT.ZERO.OR.A+C.LT.ZERO)GOTO 1000
      IF(A.EQ.ZERO.AND.C.EQ.ZERO)GOTO 1000
C
      IF(F.LE.ZERO.OR.F.GE.ONE)GOTO 10
      Z=-DLOG(ONE-F)
      Y1=Z
      IF(B.EQ.ZERO)GOTO 5
      TEMP=-B*Z
      IF(TEMP.LT.UFL)Y1=ONE/B
      IF(TEMP.GE.UFL)Y1=(ONE-DEXP(TEMP))/B
    5 CONTINUE
      Y2=Z
      IF(D.NE.ZERO)Y2=(ONE-DEXP(D*Y2))/(-D)
      QUAWAK=XI+A*Y1+C*Y2
      RETURN
C
   10 IF(F.EQ.ZERO)GOTO 20
      IF(F.EQ.ONE)GOTO 30
      GOTO 1010
   20 QUAWAK=XI
      RETURN
   30 IF(D.GT.ZERO)GOTO 1010
      IF(D.LT.ZERO)QUAWAK=XI+A/B-C/D
      IF(D.EQ.ZERO.AND.C.GT.ZERO)GOTO 1010
      IF(D.EQ.ZERO.AND.C.EQ.ZERO.AND.B.EQ.ZERO)GOTO 1010
      IF(D.EQ.ZERO.AND.C.EQ.ZERO.AND.B.GT.ZERO)QUAWAK=XI+A/B
      RETURN
C
 1000 WRITE(6,7000)
      QUAWAK=ZERO
      RETURN
 1010 WRITE(6,7010)
      QUAWAK=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUAWAK : PARAMETERS INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE QUAWAK :',
     * ' ARGUMENT OF FUNCTION INVALID')
      END
C===================================================== SAMLMR.FOR
      SUBROUTINE SAMLMR(X,N,XMOM,NMOM,A,B)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C SAMPLE L-MOMENTS OF A DATA ARRAY
C
C PARAMETERS OF ROUTINE:
C X * INPUT* ARRAY OF LENGTH N. CONTAINS THE DATA, IN ASCENDING
C ORDER.
C N * INPUT* NUMBER OF DATA VALUES
C XMOM *OUTPUT* ARRAY OF LENGTH NMOM. ON EXIT, CONTAINS THE SAMPLE
C L-MOMENTS L-1, L-2, T-3, T-4, ... .
C NMOM * INPUT* NUMBER OF L-MOMENTS TO BE FOUND. AT MOST MAX(N,20).
C A * INPUT* ) PARAMETERS OF PLOTTING
C B * INPUT* ) POSITION (SEE BELOW)
C
C FOR UNBIASED ESTIMATES (OF THE LAMBDA'S) SET A=B=ZERO. OTHERWISE,
C PLOTTING-POSITION ESTIMATORS ARE USED, BASED ON THE PLOTTING POSITION
C (J+A)/(N+B) FOR THE J'TH SMALLEST OF N OBSERVATIONS. FOR EXAMPLE,
C A=-0.35D0 AND B=0.0D0 YIELDS THE ESTIMATORS RECOMMENDED BY
C HOSKING ET AL. (1985, TECHNOMETRICS) FOR THE GEV DISTRIBUTION.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION X(N),XMOM(NMOM),SUM(20)
      DATA ZERO/0D0/,ONE/1D0/
      IF(NMOM.GT.20.OR.NMOM.GT.N)GOTO 1000
      DO 10 J=1,NMOM
   10 SUM(J)=ZERO
      IF(A.EQ.ZERO.AND.B.EQ.ZERO)GOTO 50
      IF(A.LE.-ONE.OR.A.GE.B)GOTO 1010
C
C PLOTTING-POSITION ESTIMATES OF PWM'S
C
      DO 30 I=1,N
      PPOS=(I+A)/(N+B)
      TERM=X(I)
      SUM(1)=SUM(1)+TERM
      DO 20 J=2,NMOM
      TERM=TERM*PPOS
   20 SUM(J)=SUM(J)+TERM
   30 CONTINUE
      DO 40 J=1,NMOM
   40 SUM(J)=SUM(J)/N
      GOTO 100
C
C UNBIASED ESTIMATES OF PWM'S
C
   50 DO 70 I=1,N
      Z=I
      TERM=X(I)
      SUM(1)=SUM(1)+TERM
      DO 60 J=2,NMOM
      Z=Z-ONE
      TERM=TERM*Z
   60 SUM(J)=SUM(J)+TERM
   70 CONTINUE
      Y=N
      Z=N
      SUM(1)=SUM(1)/Z
      DO 80 J=2,NMOM
      Y=Y-ONE
      Z=Z*Y
   80 SUM(J)=SUM(J)/Z
C
C L-MOMENTS
C
  100 K=NMOM
      P0=ONE
      IF(NMOM-NMOM/2*2.EQ.1)P0=-ONE
      DO 120 KK=2,NMOM
      AK=K
      P0=-P0
      P=P0
      TEMP=P*SUM(1)
      DO 110 I=1,K-1
      AI=I
      P=-P*(AK+AI-ONE)*(AK-AI)/(AI*AI)
  110 TEMP=TEMP+P*SUM(I+1)
      SUM(K)=TEMP
  120 K=K-1
      XMOM(1)=SUM(1)
      IF(NMOM.EQ.1)RETURN
      XMOM(2)=SUM(2)
      IF(SUM(2).EQ.ZERO)GOTO 1020
      IF(NMOM.EQ.2)RETURN
      DO 130 K=3,NMOM
  130 XMOM(K)=SUM(K)/SUM(2)
      RETURN
C
 1000 WRITE(6,7000)
      RETURN
 1010 WRITE(6,7010)
      RETURN
 1020 WRITE(6,7020)
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE SAMLMR : PARAMETER NMOM INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE SAMLMR :',
     * ' PLOTTING-POSITION PARAMETERS INVALID')
 7020 FORMAT(' *** ERROR *** ROUTINE SAMLMR : ALL DATA VALUES EQUAL')
      END
C===================================================== SAMLMU.FOR
      SUBROUTINE SAMLMU(X,N,XMOM,NMOM)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C SAMPLE L-MOMENTS OF A DATA ARRAY
C
C PARAMETERS OF ROUTINE:
C X * INPUT* ARRAY OF LENGTH N. CONTAINS THE DATA, IN ASCENDING
C ORDER.
C N * INPUT* NUMBER OF DATA VALUES
C XMOM *OUTPUT* ARRAY OF LENGTH NMOM. CONTAINS THE SAMPLE L-MOMENTS,
C STORED AS DESCRIBED BELOW.
C NMOM * INPUT* NUMBER OF L-MOMENTS TO BE FOUND. AT MOST 100.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      PARAMETER (MAXMOM=100)
      DOUBLE PRECISION X(N),XMOM(NMOM),COEF(2,MAXMOM)
      DATA ZERO/0D0/,ONE/1D0/,TWO/2D0/
C
      IF(NMOM.GT.MAXMOM)GOTO 1000
      DN=N
      DO 10 J=1,NMOM
   10 XMOM(J)=ZERO
      IF(NMOM.LE.2)GOTO 100
C
C UNBIASED ESTIMATES OF L-MOMENTS -- THE 'DO 30' LOOP
C RECURSIVELY CALCULATES DISCRETE LEGENDRE POLYNOMIALS, VIA
C EQ.(9) OF NEUMAN AND SCHONBACH (1974, INT.J.NUM.METH.ENG.)
C
      DO 20 J=3,NMOM
      TEMP=ONE/DFLOAT((J-1)*(N-J+1))
      COEF(1,J)=DFLOAT(J+J-3)*TEMP
      COEF(2,J)=DFLOAT((J-2)*(N+J-2))*TEMP
   20 CONTINUE
      TEMP=-DN-ONE
      CONST=ONE/(DN-ONE)
      NHALF=N/2
      DO 40 I=1,NHALF
      TEMP=TEMP+TWO
      XI=X(I)
      XII=X(N+1-I)
      TERMP=XI+XII
      TERMN=XI-XII
      XMOM(1)=XMOM(1)+TERMP
      S1=ONE
      S=TEMP*CONST
      XMOM(2)=XMOM(2)+S*TERMN
      DO 30 J=3,NMOM,2
      S2=S1
      S1=S
      S=COEF(1,J)*TEMP*S1-COEF(2,J)*S2
      XMOM(J)=XMOM(J)+S*TERMP
      IF(J.EQ.NMOM)GOTO 30
      JJ=J+1
      S2=S1
      S1=S
      S=COEF(1,JJ)*TEMP*S1-COEF(2,JJ)*S2
      XMOM(JJ)=XMOM(JJ)+S*TERMN
   30 CONTINUE
   40 CONTINUE
      IF(N.EQ.NHALF+NHALF)GOTO 60
      TERM=X(NHALF+1)
      S=ONE
      XMOM(1)=XMOM(1)+TERM
      DO 50 J=3,NMOM,2
      S=-COEF(2,J)*S
      XMOM(J)=XMOM(J)+S*TERM
   50 CONTINUE
C
C L-MOMENT RATIOS
C
   60 CONTINUE
      XMOM(1)=XMOM(1)/DN
      IF(XMOM(2).EQ.ZERO)GOTO 1010
      DO 70 J=3,NMOM
   70 XMOM(J)=XMOM(J)/XMOM(2)
      XMOM(2)=XMOM(2)/DN
      RETURN
C
C AT MOST TWO L-MOMENTS
C
  100 CONTINUE
      SUM1=ZERO
      SUM2=ZERO
      TEMP=-DN+ONE
      DO 110 I=1,N
      SUM1=SUM1+X(I)
      SUM2=SUM2+X(I)*TEMP
      TEMP=TEMP+TWO
  110 CONTINUE
      XMOM(1)=SUM1/DN
      IF(NMOM.EQ.1)RETURN
      XMOM(2)=SUM2/(DN*(DN-ONE))
      RETURN
C
 1000 WRITE(6,7000)
      RETURN
 1010 WRITE(6,7010)
      DO 1020 J=1,NMOM
 1020 XMOM(J)=ZERO
      RETURN
C
 7000 FORMAT(' ** WARNING ** ROUTINE SAMLMU :',
     * ' PARAMETER NMOM INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE SAMLMU :',
     * ' ALL DATA VALUES EQUAL')
      END
C===================================================== SAMPWM.FOR
      SUBROUTINE SAMPWM(X,N,XMOM,NMOM,A,B,KIND)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C PROBABILITY WEIGHTED MOMENTS OF A DATA ARRAY
C
C PARAMETERS OF ROUTINE:
C X * INPUT* ARRAY OF LENGTH N. CONTAINS THE DATA, IN ASCENDING
C ORDER.
C N * INPUT* NUMBER OF DATA VALUES
C XMOM *OUTPUT* ARRAY OF LENGTH NMOM. ON EXIT, CONTAINS THE SAMPLE
C PROBABILITY WEIGHTED MOMENTS. XMOM(I) CONTAINS
C ALPHA-SUB-(I-1) OR BETA-SUB-(I-1).
C NMOM * INPUT* NUMBER OF PROBABILITY WEIGHTED MOMENTS TO BE FOUND.
C AT MOST MAX(N,20).
C A * INPUT* ) PARAMETERS OF PLOTTING
C B * INPUT* ) POSITION (SEE BELOW)
C KIND * INPUT* SPECIFIES WHICH KIND OF PWM'S ARE TO BE FOUND.
C 1 ALPHA-SUB-R = E ( X (1-F(X))**R )
C 2 BETA -SUB-R = E ( X F(X)**R )
C
C FOR UNBIASED ESTIMATES SET A AND B EQUAL TO ZERO. OTHERWISE,
C PLOTTING-POSITION ESTIMATORS ARE USED, BASED ON THE PLOTTING POSITION
C (J+A)/(N+B) FOR THE J'TH SMALLEST OF N OBSERVATIONS. FOR EXAMPLE,
C A=-0.35D0 AND B=0.0D0 YIELDS THE ESTIMATORS RECOMMENDED BY
C HOSKING ET AL. (1985, TECHNOMETRICS) FOR THE GEV DISTRIBUTION.
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION X(N),XMOM(NMOM)
      DATA ZERO/0D0/,ONE/1D0/
      IF(NMOM.GT.20.OR.NMOM.GT.N)GOTO 1000
      IF(KIND.NE.1.AND.KIND.NE.2)GOTO 1010
      DO 10 J=1,NMOM
   10 XMOM(J)=ZERO
      DN=N
      IF(A.EQ.ZERO.AND.B.EQ.ZERO)GOTO 50
      IF(A.LE.-ONE.OR.A.GE.B)GOTO 1020
C
C PLOTTING-POSITION ESTIMATES OF PWM'S
C
      DO 30 I=1,N
      PPOS=(I+A)/(N+B)
      IF(KIND.EQ.1)PPOS=ONE-PPOS
      TERM=X(I)
      XMOM(1)=XMOM(1)+TERM
      DO 20 J=2,NMOM
      TERM=TERM*PPOS
   20 XMOM(J)=XMOM(J)+TERM
   30 CONTINUE
      DO 40 J=1,NMOM
   40 XMOM(J)=XMOM(J)/DN
      RETURN
C
C UNBIASED ESTIMATES OF PWM'S
C
   50 DO 70 I=1,N
      DI=I
      WEIGHT=ONE/DN
      XMOM(1)=XMOM(1)+WEIGHT*X(I)
      DO 60 J=2,NMOM
      DJ=J-ONE
      IF(KIND.EQ.1)WEIGHT=WEIGHT*(DN-DI-DJ+ONE)/(DN-DJ)
      IF(KIND.EQ.2)WEIGHT=WEIGHT*(DI-DJ)/(DN-DJ)
   60 XMOM(J)=XMOM(J)+WEIGHT*X(I)
   70 CONTINUE
      RETURN
C
 1000 WRITE(6,7000)
      RETURN
 1010 WRITE(6,7010)
      RETURN
 1020 WRITE(6,7020)
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE SAMPWM : PARAMETER NMOM INVALID')
 7010 FORMAT(' *** ERROR *** ROUTINE SAMPWM : PARAMETER KIND INVALID')
 7020 FORMAT(' *** ERROR *** ROUTINE SAMPWM :',
     * ' PLOTTING-POSITION PARAMETERS INVALID')
      END


C===================================================== DERF.FOR
      DOUBLE PRECISION FUNCTION DERF(X)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C ERROR FUNCTION
C
C BASED ON ALGORITHM 5666, J.F.HART ET AL. (1968) 'COMPUTER
C APPROXIMATIONS'
C
C ACCURATE TO 15 DECIMAL PLACES
C
      IMPLICIT DOUBLE PRECISION (A-H, O-Z)
      DATA ZERO/0D0/,ONE/1D0/,TWO/2D0/,THREE/3D0/,FOUR/4D0/,P65/0.65D0/
C
C COEFFICIENTS OF RATIONAL-FUNCTION APPROXIMATION
C
      DATA P0,P1,P2,P3,P4,P5,P6/
     * 0.22020 68679 12376 1D3, 0.22121 35961 69931 1D3,
     * 0.11207 92914 97870 9D3, 0.33912 86607 83830 0D2,
     * 0.63739 62203 53165 0D1, 0.70038 30644 43688 1D0,
     * 0.35262 49659 98910 9D-1/
      DATA Q0,Q1,Q2,Q3,Q4,Q5,Q6,Q7/
     * 0.44041 37358 24752 2D3, 0.79382 65125 19948 4D3,
     * 0.63733 36333 78831 1D3, 0.29656 42487 79673 7D3,
     * 0.86780 73220 29460 8D2, 0.16064 17757 92069 5D2,
     * 0.17556 67163 18264 2D1, 0.88388 34764 83184 4D-1/
C
C C1 IS SQRT(2), C2 IS SQRT(2/PI)
C BIG IS THE POINT AT WHICH DERF=1 TO MACHINE PRECISION
C
      DATA C1/1.4142 13562 37309 5D0/
      DATA C2/7.9788 45608 02865 4D-1/
      DATA BIG/6.25D0/,CRIT/5D0/
C
      DERF=ZERO
      IF(X.EQ.ZERO)RETURN
      XX=DABS(X)
      IF(XX.GT.BIG)GOTO 20
      EXPNTL=DEXP(-X*X)
      ZZ=DABS(X*C1)
      IF(XX.GT.CRIT)GOTO 10
      DERF=EXPNTL*((((((P6*ZZ+P5)*ZZ+P4)*ZZ+P3)*ZZ+P2)*ZZ+P1)*ZZ+P0)/
     * (((((((Q7*ZZ+Q6)*ZZ+Q5)*ZZ+Q4)*ZZ+Q3)*ZZ+Q2)*ZZ+Q1)*ZZ+Q0)
      IF(X.GT.ZERO)DERF=ONE-TWO*DERF
      IF(X.LT.ZERO)DERF=TWO*DERF-ONE
      RETURN
C
   10 DERF=EXPNTL*C2/(ZZ+ONE/(ZZ+TWO/(ZZ+THREE/(ZZ+FOUR/(ZZ+P65)))))
      IF(X.GT.ZERO)DERF=ONE-DERF
      IF(X.LT.ZERO)DERF=DERF-ONE
      RETURN
C
   20 DERF=ONE
      IF(X.LT.ZERO)DERF=-ONE
      RETURN
      END
C===================================================== DIGAMD.FOR
      DOUBLE PRECISION FUNCTION DIGAMD(X)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C DIGAMMA FUNCTION (EULER'S PSI FUNCTION) - THE FIRST DERIVATIVE OF
C LOG(GAMMA(X))
C
C BASED ON ALGORITHM AS103, APPL. STATIST. (1976) VOL.25 NO.3
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/
      DATA SMALL/1D-9/,CRIT/13D0/
C
C C1...C7 ARE THE COEFFTS OF THE ASYMPTOTIC EXPANSION OF DIGAMD
C D1 IS -(EULER'S CONSTANT)
C
      DATA C1,C2,C3,C4,C5,C6,C7,D1/
     * 0.83333 33333 33333 333D-1, -0.83333 33333 33333 333D-2,
     * 0.39682 53968 25396 825D-2, -0.41666 66666 66666 666D-2,
     * 0.75757 57575 75757 575D-2, -0.21092 79609 27960 928D-1,
     * 0.83333 33333 33333 333D-1, -0.57721 56649 01532 861D 0/
      DIGAMD=ZERO
      IF(X.LE.ZERO)GOTO 1000
C
C USE SMALL-X APPROXIMATION IF X.LE.SMALL
C
      IF(X.GT.SMALL)GOTO 10
      DIGAMD=D1-ONE/X
      RETURN
C
C REDUCE TO DIGAMD(X+N) WHERE X+N.GE.CRIT
C
   10 Y=X
   20 IF(Y.GE.CRIT)GOTO 30
      DIGAMD=DIGAMD-ONE/Y
      Y=Y+ONE
      GOTO 20
C
C USE ASYMPTOTIC EXPANSION IF Y.GE.CRIT
C
   30 DIGAMD=DIGAMD+DLOG(Y)-HALF/Y
      Y=ONE/(Y*Y)
      SUM=((((((C7*Y+C6)*Y+C5)*Y+C4)*Y+C3)*Y+C2)*Y+C1)*Y
      DIGAMD=DIGAMD-SUM
      RETURN
C
 1000 WRITE(6,7000)X
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE DIGAMD :',
     * ' ARGUMENT OUT OF RANGE :',D24.16)
      END
C===================================================== DLGAMA.FOR
      DOUBLE PRECISION FUNCTION DLGAMA(X)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C LOGARITHM OF GAMMA FUNCTION
C
C BASED ON ALGORITHM ACM291, COMMUN. ASSOC. COMPUT. MACH. (1966)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DATA SMALL,CRIT,BIG,TOOBIG/1D-7,13D0,1D9,2D36/
C
C C0 IS 0.5*LOG(2*PI)
C C1...C7 ARE THE COEFFTS OF THE ASYMPTOTIC EXPANSION OF DLGAMA
C
      DATA C0,C1,C2,C3,C4,C5,C6,C7/
     * 0.91893 85332 04672 742D 0, 0.83333 33333 33333 333D-1,
     * -0.27777 77777 77777 778D-2, 0.79365 07936 50793 651D-3,
     * -0.59523 80952 38095 238D-3, 0.84175 08417 50841 751D-3,
     * -0.19175 26917 52691 753D-2, 0.64102 56410 25641 026D-2/
C
C S1 IS -(EULER'S CONSTANT), S2 IS PI**2/12
C
      DATA S1/-0.57721 56649 01532 861D 0/
      DATA S2/ 0.82246 70334 24113 218D 0/
C
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/,TWO/2D0/
      DLGAMA=ZERO
      IF(X.LE.ZERO)GOTO 1000
      IF(X.GT.TOOBIG)GOTO 1000
C
C USE SMALL-X APPROXIMATION IF X IS NEAR 0, 1 OR 2
C
      IF(DABS(X-TWO).GT.SMALL)GOTO 10
      DLGAMA=DLOG(X-ONE)
      XX=X-TWO
      GOTO 20
   10 IF(DABS(X-ONE).GT.SMALL)GOTO 30
      XX=X-ONE
   20 DLGAMA=DLGAMA+XX*(S1+XX*S2)
      RETURN
   30 IF(X.GT.SMALL)GOTO 40
      DLGAMA=-DLOG(X)+S1*X
      RETURN
C
C REDUCE TO DLGAMA(X+N) WHERE X+N.GE.CRIT
C
   40 SUM1=ZERO
      Y=X
      IF(Y.GE.CRIT)GOTO 60
      Z=ONE
   50 Z=Z*Y
      Y=Y+ONE
      IF(Y.LT.CRIT)GOTO 50
      SUM1=SUM1-DLOG(Z)
C
C USE ASYMPTOTIC EXPANSION IF Y.GE.CRIT
C
   60 SUM1=SUM1+(Y-HALF)*DLOG(Y)-Y+C0
      SUM2=ZERO
      IF(Y.GE.BIG)GOTO 70
      Z=ONE/(Y*Y)
      SUM2=((((((C7*Z+C6)*Z+C5)*Z+C4)*Z+C3)*Z+C2)*Z+C1)/Y
   70 DLGAMA=SUM1+SUM2
      RETURN
C
 1000 WRITE(6,7000)X
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE DLGAMA :',
     * ' ARGUMENT OUT OF RANGE :',D24.16)
      END
C===================================================== DURAND.FOR
      SUBROUTINE DURAND(SEED,N,X)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C PSEUDO RANDOM NUMBER GENERATOR
C
C PARAMETERS OF ROUTINE:
C SEED *IN/OUT* SEED FOR RANDOM NUMBER GENERATOR. SHOULD BE A WHOLE
C NUMBER IN THE RANGE 2D0 TO 2147483647D0.
C N * INPUT* NUMBER OF NUMBERS TO BE GENERATED
C X *OUTPUT* ARRAY OF LENGTH N. ON EXIT, CONTAINS RANDOM NUMBERS.
C
C METHOD USED: MULTIPLICATIVE CONGRUENTIAL GENERATOR WITH BASE 2**31-1
C AND MULTIPLIER 7**5 (P.A.W. LEWIS ET AL., 1969, IBM SYSTEMS JOURNAL)
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION X(N)
      DATA AMULT/16807D0/
      DATA BASE,RBASE/2147483647D0,4.65661287524579692D-10/
      DO 10 I=1,N
      SEED=DMOD(SEED*AMULT,BASE)
      X(I)=SEED*RBASE
   10 CONTINUE
      RETURN
      END
C===================================================== GAMIND.FOR
      DOUBLE PRECISION FUNCTION GAMIND(X,ALPHA,G)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C THE INCOMPLETE GAMMA INTEGRAL
C
C BASED ON ALGORITHM AS239, APPL. STATIST. (1988) VOL.37 NO.3
C
C PARAMETERS OF ROUTINE:
C X * INPUT* ARGUMENT OF FUNCTION (UPPER LIMIT OF INTEGRATION)
C ALPHA * INPUT* SHAPE PARAMETER
C G * INPUT* LOG(GAMMA(ALPHA)). MUST BE SUPPLIED BY THE PROGRAM,
C E.G. AS DLGAMA(ALPHA).
C
C OTHER ROUTINES USED: DERF
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/,TWO/2D0/,THREE/3D0/,X13/13D0/,
     * X36/36D0/,X42/42D0/,X119/119D0/,X1620/1620D0/,X38880/38880D0/,
     * RTHALF/0.70710 67811 86547 524D0/
C
C EPS,MAXIT CONTROL THE TEST FOR CONVERGENCE OF THE SERIES AND
C CONTINUED-FRACTION EXPANSIONS.
C OFL IS A LARGE NUMBER, USED TO RESCALE THE CONTINUED FRACTION.
C UFL IS SUCH THAT EXP(UFL) IS JUST .GT. ZERO.
C AHILL CONTROLS THE SWITCH TO HILL'S APPROXIMATION.
C
      DATA EPS/1D-12/,MAXIT/100000/,OFL/1D30/,UFL/-180D0/,AHILL/1D4/
      GAMIND=ZERO
      IF(ALPHA.LE.ZERO)GOTO 1000
      IF(X.LT.ZERO)GOTO 1010
      IF(X.EQ.ZERO)RETURN
C
      IF(ALPHA.GT.AHILL)GOTO 100
      IF(X.GT.ONE.AND.X.GE.ALPHA)GOTO 50
C
C SERIES EXPANSION
C
      SUM=ONE
      TERM=ONE
      A=ALPHA
      DO 10 IT=1,MAXIT
      A=A+ONE
      TERM=TERM*X/A
      SUM=SUM+TERM
      IF(TERM.LE.EPS)GOTO 20
   10 CONTINUE
      WRITE(6,7020)
   20 ARG=ALPHA*DLOG(X)-X-G+DLOG(SUM/ALPHA)
      GAMIND=ZERO
      IF(ARG.GE.UFL)GAMIND=DEXP(ARG)
      RETURN
C
C CONTINUED-FRACTION EXPANSION
C
   50 CONTINUE
      A=ONE-ALPHA
      B=A+X+ONE
      TERM=ZERO
      PN1=ONE
      PN2=X
      PN3=X+ONE
      PN4=X*B
      RATIO=PN3/PN4
      DO 70 IT=1,MAXIT
      A=A+ONE
      B=B+TWO
      TERM=TERM+ONE
      AN=A*TERM
      PN5=B*PN3-AN*PN1
      PN6=B*PN4-AN*PN2
      IF(PN6.EQ.ZERO)GOTO 60
      RN=PN5/PN6
      DIFF=DABS(RATIO-RN)
      IF(DIFF.LE.EPS.AND.DIFF.LE.EPS*RN)GOTO 80
      RATIO=RN
   60 PN1=PN3
      PN2=PN4
      PN3=PN5
      PN4=PN6
      IF(DABS(PN5).LT.OFL)GOTO 70
      PN1=PN1/OFL
      PN2=PN2/OFL
      PN3=PN3/OFL
      PN4=PN4/OFL
   70 CONTINUE
      WRITE(6,7020)
   80 ARG=ALPHA*DLOG(X)-X-G+DLOG(RATIO)
      GAMIND=ONE
      IF(ARG.GE.UFL)GAMIND=ONE-DEXP(ARG)
      RETURN
C
C ALPHA IS LARGE: USE HILL'S APPROXIMATION (N.L. JOHNSON AND
C S. KOTZ, 1970, 'CONTINUOUS UNIVARIATE DISTRIBUTIONS 1', P.180)
C
C THE 'DO 110' LOOP CALCULATES 2*(X-ALPHA-ALPHA*DLOG(X/ALPHA)),
C USING POWER-SERIES EXPANSION TO AVOID ROUNDING ERROR
C
  100 CONTINUE
      R=ONE/DSQRT(ALPHA)
      Z=(X-ALPHA)*R
      TERM=Z*Z
      SUM=HALF*TERM
      DO 110 I=1,12
      TERM=-TERM*Z*R
      SUM=SUM+TERM/(I+TWO)
      IF(DABS(TERM).LT.EPS)GOTO 120
  110 CONTINUE
  120 WW=TWO*SUM
      W=DSQRT(WW)
      IF(X.LT.ALPHA)W=-W
      H1=ONE/THREE
      H2=-W/X36
      H3=(-WW+X13)/X1620
      H4=(X42*WW+X119)*W/X38880
      Z=(((H4*R+H3)*R+H2)*R+H1)*R+W
      GAMIND=HALF+HALF*DERF(Z*RTHALF)
      RETURN
C
 1000 WRITE(6,7000)ALPHA
      RETURN
 1010 WRITE(6,7010)X
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE GAMIND :',
     * ' SHAPE PARAMETER OUT OF RANGE :',D16.8)
 7010 FORMAT(' *** ERROR *** ROUTINE GAMIND :',
     * ' ARGUMENT OF FUNCTION OUT OF RANGE :',D16.8)
 7020 FORMAT(' ** WARNING ** ROUTINE GAMIND :',
     * ' ITERATION HAS NOT CONVERGED. RESULT MAY BE UNRELIABLE.')
      END
C===================================================== QUASTN.FOR
      DOUBLE PRECISION FUNCTION QUASTN(F)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C* VERSION 3.03 JUNE 2000 *
C* * Fixed: WRITE(6,7000) and FORMAT statement 7000 incompatible *
C* *
C***********************************************************************
C
C QUANTILE FUNCTION OF THE STANDARD NORMAL DISTRIBUTION
C
C BASED ON ALGORITHM AS241, APPL. STATIST. (1988) VOL.37 NO.3
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DATA ZERO/0D0/,HALF/0.5D0/,ONE/1D0/
      DATA SPLIT1/0.425D0/,SPLIT2/5D0/,CONST1/0.180625D0/,CONST2/1.6D0/
C
C COEFFICIENTS OF RATIONAL-FUNCTION APPROXIMATIONS
C
      DATA A0,A1,A2,A3,A4,A5,A6,A7,B1,B2,B3,B4,B5,B6,B7/
     * 0.33871 32872 79636 661D 1,
     * 0.13314 16678 91784 377D 3, 0.19715 90950 30655 144D 4,
     * 0.13731 69376 55094 611D 5, 0.45921 95393 15498 715D 5,
     * 0.67265 77092 70087 009D 5, 0.33430 57558 35881 281D 5,
     * 0.25090 80928 73012 267D 4, 0.42313 33070 16009 113D 2,
     * 0.68718 70074 92057 908D 3, 0.53941 96021 42475 111D 4,
     * 0.21213 79430 15865 959D 5, 0.39307 89580 00927 106D 5,
     * 0.28729 08573 57219 427D 5, 0.52264 95278 85285 456D 4/
      DATA C0,C1,C2,C3,C4,C5,C6,C7,D1,D2,D3,D4,D5,D6,D7/
     * 0.14234 37110 74968 358D 1,
     * 0.46303 37846 15654 530D 1, 0.57694 97221 46069 141D 1,
     * 0.36478 48324 76320 461D 1, 0.12704 58252 45236 838D 1,
     * 0.24178 07251 77450 612D 0, 0.22723 84498 92691 846D -1,
     * 0.77454 50142 78341 408D -3, 0.20531 91626 63775 882D 1,
     * 0.16763 84830 18380 385D 1, 0.68976 73349 85100 005D 0,
     * 0.14810 39764 27480 075D 0, 0.15198 66656 36164 572D -1,
     * 0.54759 38084 99534 495D -3, 0.10507 50071 64441 684D -8/
      DATA E0,E1,E2,E3,E4,E5,E6,E7,F1,F2,F3,F4,F5,F6,F7/
     * 0.66579 04643 50110 378D 1,
     * 0.54637 84911 16411 437D 1, 0.17848 26539 91729 133D 1,
     * 0.29656 05718 28504 891D 0, 0.26532 18952 65761 230D -1,
     * 0.12426 60947 38807 844D -2, 0.27115 55568 74348 758D -4,
     * 0.20103 34399 29228 813D -6, 0.59983 22065 55887 938D 0,
     * 0.13692 98809 22735 805D 0, 0.14875 36129 08506 149D -1,
     * 0.78686 91311 45613 259D -3, 0.18463 18317 51005 468D -4,
     * 0.14215 11758 31644 589D -6, 0.20442 63103 38993 979D-14/
C
      Q=F-HALF
      IF(DABS(Q).GT.SPLIT1)GOTO 10
      R=CONST1-Q*Q
      QUASTN=Q*(((((((A7*R+A6)*R+A5)*R+A4)*R+A3)*R+A2)*R+A1)*R+A0)
     * /(((((((B7*R+B6)*R+B5)*R+B4)*R+B3)*R+B2)*R+B1)*R+ONE)
      RETURN
   10 R=F
      IF(Q.GE.ZERO)R=ONE-F
      IF(R.LE.ZERO)GOTO 1000
      R=DSQRT(-DLOG(R))
      IF(R.GT.SPLIT2)GOTO 20
      R=R-CONST2
      QUASTN=(((((((C7*R+C6)*R+C5)*R+C4)*R+C3)*R+C2)*R+C1)*R+C0)
     * /(((((((D7*R+D6)*R+D5)*R+D4)*R+D3)*R+D2)*R+D1)*R+ONE)
      GOTO 30
   20 R=R-SPLIT2
      QUASTN=(((((((E7*R+E6)*R+E5)*R+E4)*R+E3)*R+E2)*R+E1)*R+E0)
     * /(((((((F7*R+F6)*R+F5)*R+F4)*R+F3)*R+F2)*R+F1)*R+ONE)
   30 IF(Q.LT.ZERO)QUASTN=-QUASTN
      RETURN
C
 1000 WRITE(6,7000)
      QUASTN=ZERO
      RETURN
C
 7000 FORMAT(' *** ERROR *** ROUTINE QUASTN :',
     * ' ARGUMENT OF FUNCTION INVALID')
      END
C===================================================== SORT.FOR
      SUBROUTINE SORT(X,N)
C***********************************************************************
C* *
C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C* *
C* J. R. M. HOSKING *
C* IBM RESEARCH DIVISION *
C* T. J. WATSON RESEARCH CENTER *
C* YORKTOWN HEIGHTS *
C* NEW YORK 10598, U.S.A. *
C* *
C* VERSION 3 AUGUST 1996 *
C* *
C***********************************************************************
C
C SORTS THE ARRAY X INTO ASCENDING ORDER
C
C PARAMETERS OF ROUTINE:
C X *IN/OUT* ARRAY OF LENGTH N. CONTAINS THE NUMBERS TO BE SORTED.
C ON EXIT, CONTAINS THE SORTED NUMBERS.
C N * INPUT* NUMBER OF ELEMENTS TO BE SORTED
C
C METHOD USED IS SHELL SORT WITH SEQUENCE OF INCREMENTS AS IN
C D.F.KNUTH (1969) 'THE ART OF COMPUTER PROGRAMMING', VOL.3, P.95
C
      IMPLICIT DOUBLE PRECISION (A-H,O-Z)
      DOUBLE PRECISION X(N)
      IF(N.LE.1)RETURN
      J=4
      DO 10 I=1,100
      J=3*J+1
      IF(J.GE.N)GOTO 20
   10 CONTINUE
   20 CONTINUE
      M=(J/3)
      DO 60 MM=1,100
      M=M/3
      IF(M.EQ.0)RETURN
      DO 50 I=M+1,N
      TEST=X(I)
      J=I
      DO 30 JJ=1,100
      J=J-M
      IF(J.LE.0)GOTO 40
      IF(TEST.GE.X(J))GOTO 40
   30 X(J+M)=X(J)
   40 CONTINUE
   50 X(J+M)=TEST
   60 CONTINUE
      END


C C===================================================== XTEST.FOR
C       PROGRAM XTEST
C C***********************************************************************
C C* *
C C* FORTRAN CODE WRITTEN FOR INCLUSION IN IBM RESEARCH REPORT RC20525, *
C C* 'FORTRAN ROUTINES FOR USE WITH THE METHOD OF L-MOMENTS, VERSION 3' *
C C* *
C C* J. R. M. HOSKING *
C C* IBM RESEARCH DIVISION *
C C* T. J. WATSON RESEARCH CENTER *
C C* YORKTOWN HEIGHTS *
C C* NEW YORK 10598, U.S.A. *
C C* *
C C* VERSION 3 AUGUST 1996 *
C C* *
C C* VERSION 3.03 JUNE 2000 *
C C* * CHARACTER variable declarations changed to conform with *
C C* Fortran-77 standard *
C C* *
C C***********************************************************************
C C
C C EXAMPLE PROGRAM TO ILLUSTRATE THE USE OF ROUTINE REGTST
C C
C C THE ROUTINE READS IN THE SAMPLE L-MOMENTS FOR DIFFERENT SITES IN A
C C REGION AND CALLS ROUTINE REGTST TO COMPUTE DISCORDANCY, HETEROGENEITY
C C AND GOODNESS-OF-FIT STATISTICS.
C C
C C PARAMETERS OF PROGRAM:
C C MAXNS - MAXIMUM NUMBER OF SITES
C C SSEED - SEED FOR RANDOM-NUMBER GENERATOR
C C NSIM - NSIM PARAMETER OF ROUTINE REGTST
C C KPRINT - OUTPUT FLAG, KPRINT PARAMETER OF ROUTINE REGTST
C C INFILE - STREAM NUMBER TO WHICH INPUT FILE IS ATTACHED
C C KOUT - STREAM NUMBER TO WHICH OUTPUT FILE IS ATTACHED
C C NPROB - NUMBER OF QUANTILES TO BE FOUND
C C A - ) PARAMETERS OF
C C B - ) PLOTTING POSITION
C C
C C ARRAYS TO BE INITIALIZED IN DATA STATEMENTS:
C C PROB - PROBABILITIES FOR WHICH QUANTILES ARE TO BE FOUND
C C
C C ROUTINES USED: REGTST AND ROUTINES CALLED BY REGTST
C C
C       IMPLICIT DOUBLE PRECISION (A-H,O-Z)
C       PARAMETER (SSEED=619145091D0,NSIM=25000,MAXNS=200)
C       PARAMETER (KPRINT=1,INFILE=7,KOUT=6,NPROB=10)
C C
C       CHARACTER*12 NAMES(MAXNS)
C       CHARACTER*60 REGNAM
C       DOUBLE PRECISION D(MAXNS),H(3),PARA(5,6),PROB(NPROB),RMOM(5),
C      * VBAR(3),VOBS(3),VSD(3),XMOM(5,MAXNS),Z(5)
C       INTEGER LEN(MAXNS)
C C
C       DATA A/0D0/,B/0D0/
C       DATA PROB/0.01D0,0.02D0,0.05D0,0.1D0,0.2D0,
C      * 0.5D0,0.90D0,0.95D0,0.99D0,0.999D0/
C C
C C READ IN THE AT-SITE L-MOMENTS.
C C DATA FILE MAY CONTAIN ANY NUMBER OF REGIONAL DATA STRUCTURES.
C C A 'REGIONAL DATA STRUCTURE' CONSISTS OF:
C C 1. ONE RECORD CONTAINING:
C C (COLUMNS 1- 4) NUMBER OF SITES IN REGION;
C C (COLUMNS 5-56) IDENTIFYING LABEL FOR THE REGION.
C C 2. FOR EACH SITE, ONE RECORD CONTAINING:
C C (COLUMNS 1-12) AN IDENTIFYING LABEL FOR THE SITE;
C C (COLUMNS 13-16) THE RECORD LENGTH AT THE SITE;
C C (COLUMNS 17-56) SAMPLE L-MOMENTS L-1, L-CV, T-3, T-4, T-5.
C WRITE(*,*),"Qui"
C OPEN(INFILE,FILE="input_viglione.txt")
C OPEN(12,FILE="input_viglione.inp2")
C READ(INFILE,*)NSITES,REGNAM
C WRITE(12,5000)NSITES
C DO 101 ISITE=1,NSITES
C       READ(INFILE,*)NAMES(ISITE),LEN(ISITE),(XMOM(I,ISITE),I=1,5)
C WRITE(12,5010)NAMES(ISITE),LEN(ISITE),(XMOM(I,ISITE),I=1,5)
C   101 CONTINUE
C CLOSE(INFILE)
C CLOSE(12)
C CLOSE(7)
C WRITE(*,*),"Qui"
C C
C OPEN(INFILE,FILE="input_viglione.inp2")
C OPEN(KOUT,FILE="input_viglione.out")
C WRITE(*,*),"Qui"
C     1 READ(INFILE,5000,END=900)NSITES
C       WRITE(KOUT,6000)NSITES
C WRITE(*,*)NSITES
C       DO 10 ISITE=1,NSITES
C       READ(INFILE,5010)NAMES(ISITE),LEN(ISITE),(XMOM(I,ISITE),I=1,5)
C WRITE(*,5010)NAMES(ISITE),LEN(ISITE),(XMOM(I,ISITE),I=1,5)
C    10 CONTINUE
C C
C C CALCULATE TEST STATISTICS
C C
C       SEED=SSEED
C       CALL REGTST(NSITES,NAMES,LEN,XMOM,A,B,SEED,NSIM,NPROB,PROB,
C      * KPRINT,KOUT,RMOM,D,VOBS,VBAR,VSD,H,Z,PARA)
C       GOTO 1
C C
C   900 CONTINUE
C       WRITE(KOUT,6010)
C       STOP
C C
C  5000 FORMAT(I4,A52)
C  5010 FORMAT(A12,I4,F8.0,4F8.5)
C  6000 FORMAT(///1X,A52,I8,' SITES')
C  6010 FORMAT(///' ALL DATA PROCESSED')
C       END
