% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svar.grid.R
\name{svar.grid}
\alias{svar.grid}
\alias{svar.grid.svarmod}
\title{Discretize a (semi)variogram model}
\usage{
svar.grid(svar, log = TRUE, ...)

\method{svar.grid}{svarmod}(svar, log = TRUE, n = 256, min = 10 *
  .Machine$double.eps, max = 1.1 * svar$range, ...)
}
\arguments{
\item{svar}{(fitted) variogram model (a \code{\link{svarmod}} 
or \code{\link{fitsvar}} object).}

\item{log}{logical. If \code{TRUE}, the variogram is discretized
in  (base 2) logarithmic scale.}

\item{...}{further arguments passed to or from other methods.}

\item{n}{number of lags. Defaults to 256.}

\item{min}{minimun lag. Defaults to \code{10*.Machine$double.eps}.}

\item{max}{maximum lag. Defaults to \code{1.1*svar$range}.}
}
\description{
Discretizes a variogram model (to speed up variogram evaluation). 
Constructor function of the \code{svar.grid-\link{class}}.
}
