\docType{data}
\name{earthquakes}
\alias{earthquakes}
\title{Earthquake data}
\format{A data frame with 1859 observations on the following 6 variables:
\describe{
  \item{date}{Date and time (POSIXct format).}
  \item{time}{Time (years since first event).}
  \item{lon}{Longitude.}
  \item{lat}{Latitude.}
  \item{depth}{Depth (km).}
  \item{mag}{Magnitude (Richter's scale).}
}}
\source{
  National Geographic Institute (IGN) of Spain: \cr
  \url{http://www.ign.es/ign/layout/sismologiaObtencionDatosSismiscos.do}.
}
\description{
  The data set consists of 1859 earthquakes (with magnitude
  above or equal to 2.0 in Richter's scale), which occurred
  from 25 November 1944 to 16 October 2013 in the northwest
  (NW) part of the Iberian Peninsula. The area considered
  is limited by the coordinates 41N-44N and 6W-10W, which
  contains the autonomic region of Galicia (Spain) and
  northern Portugal.
}
\examples{
str(earthquakes)
summary(earthquakes)
with(earthquakes, spoints(lon, lat, mag, main = "Earthquake data"))
}
\references{
  Francisco-Fernandez M., Quintela-del-Rio A. and
  Fernandez-Casal R. (2012) Nonparametric methods for
  spatial regression. An application to seismic events,
  \emph{Environmetrics}, \bold{23}, 85-93.
}
\keyword{datasets}

