\name{NegBin}
\alias{NegBin}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Family Function for Negative Binomial
}
\description{
Creates the functions needed to fit a Negative Binomial generalized smooth model via \code{\link{gsm}} with or without a known \code{theta} parameter. Adapted from the \code{negative.binomial} function in the \strong{MASS} package.
}
\usage{
NegBin(theta = NULL, link = "log")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{theta}{
the \code{size} parameter for the Negative Binomial distribution. Default of \code{NULL} indicates that \code{theta} should be estimated from the data.
}
  \item{link}{
the link function. Must be \code{log}, \code{sqrt}, \code{identity}, or an object of class \code{link-glm} (as generated by \code{\link{make.link}}).
  }
}
\details{
The Negative Binomial distribution has mean \eqn{\mu} and variance \eqn{\mu + \mu^2/\theta}, where the \code{size} parameter \eqn{\theta} is the inverse of the dispersion parameter. See \code{\link{NegBinomial}} for details.
}
\value{
An object of class "\code{family}" with the functions and expressions needed to fit the \code{gsm}. In addition to the standard values (see \code{\link{family}}), this also produces the following:
  \item{logLik}{function to evaluate the log-likelihood}
  \item{canpar}{function to compute the canonical parameter}
  \item{cumulant}{function to compute the cumulant function}
  \item{theta}{the specified \code{theta} parameter}
  \item{fixed.theta}{logical specifying if \code{theta} was provided}
}
\references{
Venables, W. N. and Ripley, B. D. (1999) Modern Applied Statistics with S-PLUS. Third Edition. Springer.

https://www.rdocumentation.org/packages/MASS/versions/7.3-51.6/topics/negative.binomial

https://www.rdocumentation.org/packages/stats/versions/3.6.2/topics/NegBinomial
}
\author{
Nathaniel E. Helwig <helwig@umn.edu>
}

%% ~Make other sections like Warning with \section{Warning }{....} ~

\seealso{
\code{\link{gsm}} for fitting generalized smooth models with Negative Binomial responses

\code{\link{theta.mle}} for maximum likelihood estimation of theta
}
\examples{
# generate data
n <- 1000
x <- seq(0, 1, length.out = n)
fx <- 3 * x + sin(2 * pi * x) - 1.5

# negative binomial (size = 1/2, log link)
set.seed(1)
y <- rnbinom(n = n, size = 1/2, mu = exp(fx))

# fit model (known theta)
mod <- gsm(y ~ x, family = NegBin(theta = 1/2), knots = 10)
mean((mod$linear.predictors - fx)^2)
mod$family$theta   # fixed theta

# fit model (unknown theta)
mod <- gsm(y ~ x, family = NegBin, knots = 10)
mean((mod$linear.predictors - fx)^2)
mod$family$theta   # estimated theta

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory (show via RShowDoc("KEYWORDS")):
\keyword{ distribution }
\keyword{ regression }
