% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agePyramidPlot.R
\name{agePyramidPlot}
\alias{agePyramidPlot}
\title{Form age pyramid plot}
\usage{
agePyramidPlot(
  males,
  females,
  ageLabels,
  mcol,
  fcol,
  laxlab,
  raxlab,
  gap,
  currentDate
)
}
\arguments{
\item{males}{integer vector with the number of males in age groups
corresponding to the position in the vector}

\item{females}{integer vector with the number of females in age groups
corresponding to the position in the vector}

\item{ageLabels}{character vector of labels for the categories represented
by each pair of bars. There should be a label for each lx or rx value,
even if empty. If labels is a matrix or data frame, the first two columns
will be used for the left and right category labels respectively.}

\item{mcol}{color for the male (left) side of the plot}

\item{fcol}{color for the female (right) side of the plot}

\item{laxlab}{label for the male (left) side of the plot}

\item{raxlab}{label for the female (right) side of the plot}

\item{gap}{numeric value for one half of the space between the two sets
of bars for the \code{ageLabels} in user units}

\item{currentDate}{POSIXct date object indicating the date corresponding to
the date the pedigree census occurred.}
}
\value{
The return value of par("mar") when the function was called.
}
\description{
Form age pyramid plot
}
