% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toCharacter.R
\name{toCharacter}
\alias{toCharacter}
\title{Force dataframe columns to character}
\usage{
toCharacter(df, headers = c("id", "sire", "dam"))
}
\arguments{
\item{df}{a dataframe where the first three columns can be coerced to
character.}

\item{headers}{character vector with the columns to be converted to
character class. Defaults to \code{c("id", "sire", "dam")}/}
}
\value{
A dataframe with the specified columns converted to class
"character" for display with xtables (in shiny)
}
\description{
Converts designated columns of a dataframe to character. Defaults to
converting columns \code{id}, \code{sire}, and \code{dam}.
}
\examples{
\donttest{
library(nprcgenekeepr)
pedGood <- nprcgenekeepr::pedGood
names(pedGood) <- c("id", "sire", "dam", "sex", "birth")
class(pedGood[["id"]])
pedGood <- toCharacter(pedGood)
class(pedGood[["id"]])
}

}
