\name{plot.nparLD}
\alias{plot}
\alias{plot.nparLD}
\title{Plot for nparLD}
\description{
This function displays the plot of the relative treatment effect (RTE) at each time point with the corresponding pointwise confidence interval from \code{\link{nparLD}}.
}

\usage{
\method{plot}{nparLD}(x, \ldots)
}

\arguments{
  \item{x}{an \code{nparLD} class object generated by \code{\link{nparLD}} (see examples).}
  \item{\ldots}{further arguments passed to or from other methods.}
}

\details{
The Fx-LD-Fy design refers to the experimental design with x whole-plot factor and y sub-plot factors. A whole-plot (between-subjects) factor refers to a factor effective for each subject at all times. A sub-plot (within-subjects) factor refers to a factor effective at a single time point for all time curves and all subjects. The LD-Fy design refers to the experimental design with no whole-plot factor. See Brunner et al. (2002) for more examples.
}

\value{
A list with the following numeric components.
  \item{RTE}{
summary of the relative treatment effect (RTE) in a n-by-3 matrix form, where n is the total number of time1, time2, and group levels, and group-time interactions; the summary includes the mean of the ranks (RankMeans) in the 1st column, number of observations without counting the repeated measurements within the cell (Nobs) in the 2nd column, and the relative treatment effect (RTE) in the 3rd column.
}
  \item{Wald.test}{the test statistic, the degrees of freedom (df) of the central chi-squared distribution, and the corresponding p-value of the Wald-type test.}
  \item{ANOVA.test}{the test statistic, the numerator degrees of freedom (df) of the central F distribution, and the corresponding p-value of the ANOVA-type test; the denominator degrees of freedom is set to infinity.}
  \item{covariance}{the covariance matrix.}
  \item{Conf.Int}{the (pointwise) 100(1-alpha) percent confidence intervals. See \code{\link{ld.ci}} for details.}
  \item{\ldots}{Other function-specific outputs. For example, \code{ANOVA.test.mod.Box} which is applicable to designs with whole-plot factor(s).}
}

\section{On the Test Statistics}{

Although we provide both Wald-type statistic (WTS, see \code{Wald.test}) and ANOVA-type statistic with the denominator degrees of freedom set to infinity (ATS, see \code{ANOVA.test}), ATS is typically preferred to WTS as it requires less assumptions on the covariance matrix and it has superior small sample performances. Moreover, for the main effects and interactions involving only the whole-plot factors, the modified ANOVA-type statistic with Box (1954) approximation (\code{ANOVA.test.mod.Box}) is preferred to ATS. See Brunner et al. (2002) for more details.

}

\references{

Box, G.E.P. (1954). Some theorems on quadratic forms applied in the study of analysis of variance problems, I. Effect of inequality of variance in the one-way classification. \emph{Annals of Mathematical Statistics}, 25, 290-302.\cr

Brunner, E., Domhof, S., and Langer, F. (2002). \emph{Nonparametric Analysis of Longitudinal Data in Factorial Experiments},
Wiley, New York.\cr

Brunner, E. and Langer, F. (1999). \emph{Nichtparametrische Analyse longitudinaler Daten}, 
R. Oldenbourg Verlag, Munchen Wien.

}
\author{Kimihiro Noguchi, Karthinathan Thangavelu, Frank Konietschke, Yulia Gel, Edgar Brunner}

\seealso{\code{\link{nparLD}}, \code{\link{ld.f1}}, \code{\link{ld.f2}}, \code{\link{f1.ld.f1}}, \code{\link{f1.ld.f2}}, \code{\link{f2.ld.f1}}, \code{\link{ld.ci}}, \code{\link{amylase}}, \code{\link{edema}}, \code{\link{shoulder}}, \code{\link{tree}}, \code{\link{panic}}, \code{\link{panic2}}, \code{\link{plasma}}, \code{\link{dental}}, \code{\link{rat}}, \code{\link{respiration}}}

\examples{

## Example with the "Panic disorder study I" data (LD-F1 design) ##
data(panic)
ex.f1.np<-nparLD(resp~time, data=panic, subject="subject", description=FALSE, 
order.warning=FALSE)
plot.nparLD(ex.f1.np)

}
\keyword{htest}
