npudens <-
  function(bws = stop(paste("bandwidths are required to perform the estimate!",
             "please set 'bws'")), ...){
    args = list(...)
    
    if (!is.null(bws$formula) && is.null(args$tdat))
      UseMethod("npudens",bws$formula)
    else if (!is.null(args$data) || !is.null(args$newdata))
      stop("data and newdata specified, but bws has no formula")
    else if (!is.null(bws$call) && is.null(args$tdat))
      UseMethod("npudens",bws$call)
    else
      UseMethod("npudens",bws)
  }

npudens.formula <-
  function(bws, data = NULL, newdata = NULL, ...){

    tt <- terms(bws)

    m <- match(c("formula", "data", "subset", "na.action"),
               names(bws$call), nomatch = 0)

    tmf <- bws$call[c(1,m)]
    tmf[[1]] <- as.name("model.frame")
    tmf[["formula"]] <- tt
    umf <- tmf <- eval(tmf)

    tdat <- tmf[, attr(attr(tmf, "terms"),"term.labels"), drop = FALSE]

    if ((has.eval <- !is.null(newdata))) {
      umf <- emf <- model.frame(tt, data = newdata)

      edat <- emf[, attr(attr(emf, "terms"),"term.labels"), drop = FALSE]
    }

    ev <- 
      eval(parse(text=paste("npudens(tdat = tdat,",
                   ifelse(has.eval,"edat = edat,",""), "bws = bws, ...)")))
    ev$rows.omit <- as.vector(attr(umf,"na.action"))
    ev$nobs.omit <- length(ev$rows.omit)
    return(ev)
  }

npudens.call <-
  function(bws, ...) {
    npudens(bws, tdat = eval(bws$call[["dat"]], environment(bws$call)),
            ...)
  }

npudens.bandwidth <-
  function(bws,
           tdat = stop("invoked without training data 'tdat'"),
           edat, ...){

  no.e = missing(edat)

  tdat = toFrame(tdat)

  if (!no.e)
    edat = toFrame(edat)

  if (!(no.e || tdat %~% edat ))
    stop("tdat and edat are not similar data frames!")

  if (length(bws$bw) != length(tdat))
    stop("length of bandwidth vector does not match number of columns of 'tdat'")

  ccon = unlist(lapply(as.data.frame(tdat[,bws$icon]),class))
  if ((any(bws$icon) && !all((ccon == class(integer(0))) | (ccon == class(numeric(0))))) ||
      (any(bws$iord) && !all(unlist(lapply(as.data.frame(tdat[,bws$iord]),class)) ==
                             class(ordered(0)))) ||
      (any(bws$iuno) && !all(unlist(lapply(as.data.frame(tdat[,bws$iuno]),class)) ==
                             class(factor(0)))))
    stop("supplied bandwidths do not match 'tdat' in type")

  tdat <- na.omit(tdat)
  rows.omit <- unclass(na.action(tdat))

  if (!no.e){
    edat <- na.omit(edat)
    rows.omit <- unclass(na.action(edat))
  }

  tnrow = nrow(tdat)
  enrow = ifelse(no.e,tnrow,nrow(edat))

  ## re-assign levels in training and evaluation data to ensure correct
  ## conversion to numeric type.
    
  tdat <- relevel(tdat, bws$xdati)
  
  if (!no.e)
    edat <- relevel(edat, bws$xdati)

  ## grab the evaluation data before it is converted to numeric
  if(no.e)
    teval <- tdat
  else
    teval <- edat

  ## put the unordered, ordered, and continuous data in their own objects
  ## data that is not a factor is continuous.
  
  tdat = toMatrix(tdat)

  tuno = tdat[, bws$iuno, drop = FALSE]
  tcon = tdat[, bws$icon, drop = FALSE]
  tord = tdat[, bws$iord, drop = FALSE]

  if (!no.e){
    edat = toMatrix(edat)

    euno = edat[, bws$iuno, drop = FALSE]
    econ = edat[, bws$icon, drop = FALSE]
    eord = edat[, bws$iord, drop = FALSE]

  } else {
    euno = data.frame()
    eord = data.frame()
    econ = data.frame()
  }

  
  myopti = list(
    num_obs_train = tnrow,
    num_obs_eval = enrow,
    num_uno = bws$nuno,
    num_ord = bws$nord,
    num_con = bws$ncon,
    int_LARGE_SF = ifelse(bws$scaling, SF_NORMAL, SF_ARB),
    BANDWIDTH_den_extern = switch(bws$type,
      fixed = BW_FIXED,
      generalized_nn = BW_GEN_NN,
      adaptive_nn = BW_ADAP_NN),
    int_MINIMIZE_IO=ifelse(options('np.messages'), IO_MIN_FALSE, IO_MIN_TRUE), 
    kerneval = switch(bws$ckertype,
      gaussian = CKER_GAUSS + bws$ckerorder/2 - 1,
      epanechnikov = CKER_EPAN + bws$ckerorder/2 - 1,
      uniform = CKER_UNI),
    no.e = no.e,
    mcv.numRow = attr(bws$xmcv, "num.row"),
    densOrDist = NP_DO_DENS)
  
  myout=
    .C("np_density", as.double(tuno), as.double(tord), as.double(tcon),
       as.double(euno),  as.double(eord),  as.double(econ), 
       as.double(c(bws$bw[bws$icon],bws$bw[bws$iuno],bws$bw[bws$iord])),
       as.double(bws$xmcv), as.double(attr(bws$xmcv, "pad.num")),
       as.integer(myopti),
       dens = double(enrow),
       derr = double(enrow),
       log_likelihood = double(1),
       PACKAGE="np" )[c("dens","derr", "log_likelihood")]

  ev <- npdensity(bws=bws, eval=teval, dens = myout$dens,
                  derr = myout$derr, ll = myout$log_likelihood,
                  ntrain = tnrow, trainiseval = no.e,
                  rows.omit = rows.omit)
  return(ev)
}

npudens.default <-
  function(bws,
           tdat = stop("invoked without training data 'tdat'"),
           edat, ...){
    tdat <- toFrame(tdat)

    tbw = bandwidth( bws,
      ...,
      nobs = 0,
      xdati = untangle(tdat),
      xnames = names(tdat) )

    eval(parse(text=paste("npudens.bandwidth(tdat = tdat, bws = tbw",
                 ifelse(missing(edat), "",", edat = edat"), ")")))
  }

