% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{datafile.character}
\alias{datafile.character}
\title{Identify the Datafile for a Model}
\usage{
\method{datafile}{character}(x, ...)
}
\arguments{
\item{x}{the model name or path to a control stream}

\item{...}{ext can be passed to modelfile, etc.}
}
\value{
character
}
\description{
Identifies the datafile used by a model. 
Expresses it relative to current working directory.
}
\examples{
library(spec)
source <- system.file(package = 'nonmemica','project')
target <- tempdir()
target <- gsub('\\\\\\\\','/',target) # for windows
file.copy(source,target,recursive = TRUE)
project <- file.path(target,'project','model')
options(project = project)
library(magrittr)
1001 \%>\% datafile
datafile(1001) \%matches\% specfile(1001)
1001 \%>\% specfile
1001 \%>\% specfile \%>\% read.spec
}
