% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Options.R
\name{noctua_options}
\alias{noctua_options}
\title{A method to configure noctua backend options.}
\usage{
noctua_options(
  file_parser = c("data.table", "vroom"),
  cache_size = 0,
  clear_cache = FALSE,
  retry = 5,
  retry_quiet = FALSE
)
}
\arguments{
\item{file_parser}{Method to read and write tables to Athena, currently defaults to data.table}

\item{cache_size}{Number of queries to be cached. Currently only support caching up to 100 distinct queries.}

\item{clear_cache}{Clears all previous cached query metadata}

\item{retry}{Maximum number of requests to attempt.}

\item{retry_quiet}{If \code{FALSE}, will print a message from retry displaying how long until the next request.}
}
\value{
\code{noctua_options()} returns \code{NULL}, invisibly.
}
\description{
\code{noctua_options()} provides a method to change the backend. This includes changing the file parser,
 whether \code{noctua} should cache query ids locally and number of retries on a failed api call.
}
\examples{
library(noctua)

# change file parser from default data.table to vroom
noctua_options("vroom")

# cache queries locally
noctua_options(cache_size = 5)
}
