% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{funs.auxcovtct}
\alias{funs.auxcovtct}
\alias{cov.2cells}
\alias{cov.cell.col}
\alias{covNijCk}
\alias{cov.2cols}
\alias{covCiCj}
\title{Auxiliary Functions for Computing Covariances Between Cell Counts in the TCT}
\usage{
cov.2cells(i, j, k, l, ct, covN)

cov.cell.col(i, j, k, ct, covN)

covNijCk(i, j, k, ct, covN)

cov.2cols(i, j, ct, covN)

covCiCj(i, j, ct, covN)
}
\arguments{
\item{i, j, k, l}{Indices of the cell counts or column sums whose covariance is to be computed. All four are
needed for \code{cov.2cells} referring to cells \eqn{(i,j)} and \eqn{(k,l)}; only three indices \eqn{i,j,k} are needed for
\code{cov.cell.col} and \code{covNijCk} referring to cell \eqn{(i,j)} and column \eqn{k};
only two indices \eqn{i,j} are needed for \code{cov2cols} and \code{covCiCj} referring to columns \eqn{i} and \eqn{j}.}

\item{ct}{A nearest neighbor contingency table}

\item{covN}{The \eqn{k^2 \times k^2} covariance matrix of row-wise vectorized cell counts of NNCT, \code{ct}.}
}
\value{
\code{cov.2cells} returns the covariance between two cell counts \eqn{N_{ij}} and \eqn{N_{kl}} in an NNCT,
\code{cov.cell.col} and \code{covNijCk} return the covariance between cell count \eqn{N_{ij}}
and sum of column \eqn{k}, \eqn{C_k},
\code{cov2cols} and \code{covCiCj} return the covariance between sums of two columns, 
\eqn{C_i} and \eqn{C_j}.
}
\description{
Five functions: \code{cov.2cells}, \code{cov.cell.col}, \code{covNijCk}, \code{cov2cols}
and \code{covCiCj}

These are auxiliary functions for computing covariances between entries in the TCT for the types I-IV
cell-specific tests. The covariances between \eqn{T_{ij}} values for \eqn{i,j=1,\ldots,k} in the TCT require covariances
between two cells in the NNCT, between a cell and column sum, and between two column sums in the NNCT.
\code{cov.2cells} computes the covariance between two cell counts \eqn{N_{ij}} and \eqn{N_{kl}} in an NNCT,
\code{cov.cell.col} and \code{covNijCk} are equivalent and they compute the covariance between cell count \eqn{N_{ij}}
and sum of column \eqn{k}, \eqn{C_k},
\code{cov2cols} and \code{covCiCj} are equivalent and they compute the covariance between sums of two columns, 
\eqn{C_i} and \eqn{C_j}.
The index arguments refer to which entry or column sum is intended in the NNCT. 
The argument \code{covN} must be the covariance between \eqn{N_{ij}} values which are obtained from NNCT by row-wise vectorization.
These covariances are valid under RL or conditional on \eqn{Q} and \eqn{R} under CSR.
}
\examples{
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:2,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

cov.2cells(1,1,1,2,ct,covN)

cov.cell.col(2,2,1,ct,covN)
covNijCk(2,2,1,ct,covN)

cov.2cols(2,1,ct,covN)
covCiCj(2,1,ct,covN)

#############
n<-40
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
cls<-sample(1:4,n,replace = TRUE)  #or try cls<-rep(1:2,c(10,10))
ct<-nnct(ipd,cls)

W<-Wmat(ipd)
Qv<-Qvec(W)$q
Rv<-Rval(W)
varN<-var.nnct(ct,Qv,Rv)
covN<-cov.nnct(ct,varN,Qv,Rv)

cov.2cells(2,3,1,2,ct,covN)

cov.cell.col(1,1,2,ct,covN)
covNijCk(1,1,2,ct,covN)

cov.2cols(3,4,ct,covN)
covCiCj(3,4,ct,covN)

}
\seealso{
\code{\link{cov.tct}} and \code{\link{cov.nnct}}
}
\author{
Elvan Ceyhan
}
