% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.R
\name{Ninv}
\alias{Ninv}
\title{Vector of Shared NNs and Number of Reflexive NNs}
\usage{
Ninv(x, is.ipd = TRUE, ...)
}
\arguments{
\item{x}{The IPD matrix (if \code{is.ipd=TRUE}) or a data set of points in matrix or data frame form where points
correspond to the rows (if \code{is.ipd = FALSEALSE}).}

\item{is.ipd}{A logical parameter (default=\code{TRUE}). If \code{TRUE}, \code{x} is taken as the inter-point distance
matrix, otherwise, \code{x} is taken as the data set with rows representing the data points.}

\item{\dots}{are for further arguments, such as \code{method} and \code{p}, passed to the \code{\link[stats]{dist}} function.}
}
\value{
Returns a \code{list} with two elements
 \item{Qvec}{vector of \eqn{Q_j} values}
 \item{R}{number of reflexive points}
}
\description{
Returns the \code{Qvec} and \code{R} where \eqn{Qvec=(Q_0,Q_1,\ldots)} with
\eqn{Q_j} is the number of points shared as a NN
by \eqn{j} other points i.e. number of points that are NN of \eqn{i} points, for \eqn{i=0,1,2,\ldots}
and \code{R} is the number of reflexive pairs where A and B are reflexive iff they are NN to each other.
}
\examples{
#3D data points
n<-20  #or try sample(1:20,1)
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
W<-Wmat(ipd)
sharedNN(W)
Qvec(W)
Ninv(ipd)
Ninv(Y,is.ipd = FALSE)
Ninv(Y,is.ipd = FALSE,method="max")

#1D data points
n<-15
X<-as.matrix(runif(n))# need to be entered as a matrix with one column 
#(i.e., a column vector), hence X<-runif(n) would not work
ipd<-ipd.mat(X)
W<-Wmat(ipd)
sharedNN(W)
Qvec(W)
Ninv(ipd)

#with possible ties in the data
Y<-matrix(round(runif(30)*10),ncol=3)
ny<-nrow(Y)
ipd<-ipd.mat(Y)
W<-Wmat(ipd)
sharedNN(W)
Qvec(W)
Ninv(ipd)

}
\seealso{
\code{\link{Qval}}, \code{\link{Qvec}}, \code{\link{sharedNN}}, \code{\link{Rval}} 
and \code{\link{QRval}}
}
\author{
Elvan Ceyhan
}
