% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NNCTFunctions.r
\name{funsQandR}
\alias{funsQandR}
\alias{Qval}
\alias{Qvec}
\alias{sharedNN}
\alias{Rval}
\title{Functions for the Number of Shared NNs, Shared NN vector and the number of reflexive NNs}
\usage{
Qval(W)

Qvec(W)

sharedNN(W)

Rval(W)
}
\arguments{
\item{W}{The incidence matrix, \eqn{W}, for the NN digraph}
}
\value{
\code{Qval} returns the \eqn{Q} value
\code{Qvec} returns a \code{list} with two elements
 \item{q}{the \eqn{Q} value, the number of shared NNs}
 \item{qvec}{the \code{vector} of \eqn{Q_j} values} 
\code{sharedNN} returns a \code{matrix} with 2 rows, where first row is the \eqn{j} values and second row is
the corresponding vector of \eqn{Q_j} values
\code{Rval}{the \eqn{R} value, the number of reflexive NNs}

See the description above for the details of these quantities.
}
\description{
Four functions: \code{Qval}, \code{Qvec}, \code{sharedNN} and \code{Rval}.

\code{Qval} returns the \eqn{Q} value, the number of points with shared nearest neighbors (NNs), which occurs when two or 
more points share a NN, for data in any dimension. 

\code{Qvec} returns the Q-value and also yields the Qv vector \eqn{Qv=(Q_0,Q_1,\ldots)} as well for data in any 
dimension, where \eqn{Q_j} is the number of points shared as a NN by \eqn{j} other points. 

\code{sharedNN} returns the \code{vector} of number of points with shared NNs, \eqn{Q=(Q_0,Q_1,\ldots)} where \eqn{Q_i} is
the number of points that are NN to \eqn{i} points, and if a point is a NN of \eqn{i} points, then there are \eqn{i(i-1)} 
points that share a NN. So \eqn{Q=\sum_{i>1} i(i-1)Q_i}.

\code{Rval} returns the number of reflexive NNs, R (i.e., twice the number of reflexive NN pairs).

These quantities are used, e.g., in computing the variances and covariances of the entries of the
nearest neighbor contingency tables used for Dixon's tests and other NNCT tests. 
The input must be the incidence matrix, \eqn{W}, of the NN digraph.
}
\examples{
#Examples for Qval
#3D data points
n<-10
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
W<-Wmat(ipd)
Qval(W)

#1D data points
X<-as.matrix(runif(10)) # need to be entered as a matrix with one column
#(i.e., a column vector), hence X<-runif(10) would not work
ipd<-ipd.mat(X)
W<-Wmat(ipd)
Qval(W)

#with ties=TRUE in the data
Y<-matrix(round(runif(15)*10),ncol=3)
ipd<-ipd.mat(Y)
W<-Wmat(ipd,ties=TRUE)
Qval(W)

#with ties=TRUE in the data
Y<-matrix(round(runif(15)*10),ncol=3)
ipd<-ipd.mat(Y)
W<-Wmat(ipd,ties=TRUE)
Qval(W)

#Examples for Qvec
#3D data points
n<-10
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
W<-Wmat(ipd)
Qvec(W)

#2D data points
n<-15
Y<-matrix(runif(2*n),ncol=2)
ipd<-ipd.mat(Y)
W<-Wmat(ipd)
Qvec(W)

#1D data points
X<-as.matrix(runif(15)) # need to be entered as a matrix with one column
#(i.e., a column vector), hence X<-runif(15) would not work
ipd<-ipd.mat(X)
W<-Wmat(ipd)
Qvec(W)

#with ties=TRUE in the data
Y<-matrix(round(runif(15)*10),ncol=3)
ipd<-ipd.mat(Y)
W<-Wmat(ipd,ties=TRUE)
Qvec(W)

#Examples for sharedNN
#3D data points
n<-10
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
W<-Wmat(ipd)
sharedNN(W)
Qvec(W)

#1D data points
X<-as.matrix(runif(15)) # need to be entered as a matrix with one column
#(i.e., a column vector), hence X<-runif(5) would not work
ipd<-ipd.mat(X)
W<-Wmat(ipd)
sharedNN(W)
Qvec(W)

#2D data points
n<-15
Y<-matrix(runif(2*n),ncol=2)
ipd<-ipd.mat(Y)
W<-Wmat(ipd)
sharedNN(W)
Qvec(W)

#with ties=TRUE in the data
Y<-matrix(round(runif(30)*10),ncol=3)
ipd<-ipd.mat(Y)
W<-Wmat(ipd,ties=TRUE)
sharedNN(W)

#Examples for Rval
#3D data points
n<-10
Y<-matrix(runif(3*n),ncol=3)
ipd<-ipd.mat(Y)
W<-Wmat(ipd)
Rval(W)

#1D data points
X<-as.matrix(runif(15)) # need to be entered as a matrix with one column
#(i.e., a column vector), hence X<-runif(5) would not work
ipd<-ipd.mat(X)
W<-Wmat(ipd)
Rval(W)

#with ties=TRUE in the data
Y<-matrix(round(runif(30)*10),ncol=3)
ipd<-ipd.mat(Y)
W<-Wmat(ipd,ties=TRUE)
Rval(W)

}
\seealso{
\code{\link{Tval}}, \code{\link{QRval}}, \code{\link{sharedNNmc}} and \code{\link{Ninv}}
}
\author{
Elvan Ceyhan
}
