% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_aspect.R
\name{raster_aspect}
\alias{raster_aspect}
\title{Wrapper for \code{raster::terrain} for calculating aspect on \code{stars} objects}
\usage{
raster_aspect(x)
}
\arguments{
\item{x}{A \code{stars} object}
}
\value{
A \code{stars} object with the aspect values, in decimal degrees
}
\description{
This is a wrapper around \code{raster::terrain} with \code{opt="aspect"}, to calculate topographic aspect on \code{stars} objects without needing to convert to and from a \code{Raster*} object.
}
\examples{
library(stars)
data(dem)
aspect = raster_aspect(dem)
plot(dem)
plot(aspect)

}
