% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condition.R
\name{\%OR\%}
\alias{\%OR\%}
\title{Combine selections with OR}
\usage{
cond1 \%OR\% cond2
}
\arguments{
\item{cond1}{First \code{\link{condition}}.}

\item{cond2}{Second \code{\link{condition}}.}
}
\value{
Object of class 'data.tree'.
}
\description{
Combine selections with OR
}
\examples{
data("Woods2010", package = "netmeta")
p1 <- pairwise(treatment, event = r, n = N, studlab = author,
  data = Woods2010, sm = "OR")
net1 <- netmeta(p1, small.values = "good")

A <- condition("retainOrder", c("Placebo", "Salmeterol", "SFC"))
B <- condition("betterEqual", "Fluticasone", 2)

nmarank(net1, A \%OR\% B, nsim = 500)

}
\seealso{
\code{\link{condition}}, \code{\link{nmarank}}
}
