% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_nlme.R
\name{simulate_nlme}
\alias{simulate_nlme}
\title{Simulate samples from a nonlinear mixed model from fixed effects}
\usage{
simulate_nlme(object, nsim = 1, psim = 1, value = c("matrix",
  "data.frame"), ...)
}
\arguments{
\item{object}{object of class \code{\link[nlme]{gnls}} or \code{\link[nlme]{nlme}}}

\item{nsim}{number of samples, default 1}

\item{psim}{simulation level for vector of fixed parameters for \code{\link{simulate_nlme_one}}}

\item{value}{whether to return a matrix (default) or an augmented data frame}

\item{...}{additional arguments to be passed to either \code{\link{simulate_gnls}} or \code{\link{simulate_nlme_one}}}
}
\value{
It returns a matrix with simulated values from the original object
with number of rows equal to the number of rows of \code{\link{fitted}} and number
of columns equal to the number of simulated samples (\sQuote{nsim}). In the case of 'data.frame'
it returns an augmented data.frame, which can potentially be a very large object, but which
makes furhter plotting more convenient.
}
\description{
Simulate multiple samples from a nonlinear model
}
\details{
The details can be found in either \code{\link{simulate_gnls}} or \code{\link{simulate_nlme_one}}.
This function is very simple and it only sets up a matrix and a loop in order to simulate several instances of 
model outputs.
}
\examples{
\donttest{
require(car)
require(nlme)
data(barley)
barley2 <- subset(barley, year < 1974)
fit.lp.gnls2 <- gnls(yield ~ SSlinp(NF, a, b, xs), data = barley2)
barley2$year.f <- as.factor(barley2$year)
cfs <- coef(fit.lp.gnls2)
fit.lp.gnls3 <- update(fit.lp.gnls2, 
                      params = list(a + b + xs ~ year.f),
                      start = c(cfs[1], 0, 0, 0, 
                                cfs[2], 0, 0, 0,
                                cfs[3], 0, 0, 0))
                                
sims <- simulate_nlme(fit.lp.gnls3, nsim = 3)
}

}
